/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.odd.Enum.BillStatusEnum;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddDetailVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"odd"})
public class OddController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String USE_TYPE_DEF_CODE = "fbxt-use-type";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOddService service;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOddInfoService oddInfoService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OddVO> saveOrUpdate(@RequestBody OddVO saveorUpdateVO) {
        CommonResponse<OddVO> oddVOCommonResponse = this.service.saveOrUpdate(saveorUpdateVO);
        OddVO data = (OddVO)oddVOCommonResponse.getData();
        List oddInfoVOList = data.getOddInfoEntities();
        oddInfoVOList.forEach(info -> {
            OddDetailVO redirect = this.service.queryRedirect(info.getId());
            this.logger.info("--->> \u6d4b\u8bd5\u67e5\u8be2\u6e05\u5355\u4e3b\u952e: " + info.getId());
            this.logger.info("--->> \u6d4b\u8bd5\u67e5\u8be2\u8f6c\u6263\u7ed3\u679c: " + redirect);
            if (redirect != null && redirect.getZkcontractName() != null) {
                info.setZkcontract(redirect.getZkcontractName());
            } else {
                info.setZkcontract("");
            }
            if (redirect != null && redirect.getRedirectcorp() != null) {
                info.setZkcorpname(redirect.getRedirectcorp());
            } else {
                info.setZkcorpname("");
            }
            OddInfoEntity oddInfoEntity = (OddInfoEntity)((Object)((Object)BeanMapper.map((Object)info, OddInfoEntity.class)));
            this.oddInfoService.updateById((Object)oddInfoEntity);
        });
        data.setOddInfoEntities(oddInfoVOList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)data);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddVO> vos) {
        this.service.del(vos);
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OddVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter("eq", (Object)1));
        param.getParams().put("importFlag", new Parameter("eq", (Object)0));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OddVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryzcList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OddVO>> queryzcList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter("eq", (Object)0));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("importFlag", new Parameter("eq", (Object)0));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OddVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getcount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> getcount(@RequestBody QueryParam param) {
        CommonResponse<IPage<OddVO>> response = this.queryzcList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)((IPage)response.getData()).getTotal());
    }

    @RequestMapping(value={"/queryDetailsList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailsList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("cropName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList commonOrgIds = new ArrayList();
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<OddDetailVO> list = this.service.queryDetailsList((Page<OddDetailVO>)page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelExportDetails"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDetails(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> res = this.queryDetailsList(param);
        List list = new ArrayList();
        if (res.getData() != null) {
            JSONArray jsonArray = ((JSONObject)res.getData()).getJSONArray("records");
            list = JSONObject.parseArray((String)jsonArray.toJSONString(), OddDetailVO.class);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(vo -> {
                String settleNcFlagName = "";
                settleNcFlagName = vo.getSettleNcFlag() != null && vo.getSettleNcFlag() == 1 ? "NC\u5df2\u7ed3\u7b97" : "NC\u672a\u7ed3\u7b97";
                vo.setSettleNcFlagName(settleNcFlagName);
                String useTypeName = "";
                if ("1330815360484229121".equals(vo.getUseType())) {
                    useTypeName = "\u96f6\u661f\u7528\u5de5";
                } else if ("1330815434631135234".equals(vo.getUseType())) {
                    useTypeName = "\u4e34\u65f6\u673a\u68b0";
                } else if ("1330815490885140481".equals(vo.getUseType())) {
                    useTypeName = "\u53d8\u66f4\u7b7e\u8bc1";
                }
                vo.setUseTypeName(useTypeName);
                String belongName = "";
                if ("1330815675283521538".equals(vo.getBelong())) {
                    belongName = "\u7ef4\u4fee";
                } else if ("1330815744443400193".equals(vo.getBelong())) {
                    belongName = "\u4e1a\u4e3b\u539f\u56e0";
                } else if ("1330815794078793730".equals(vo.getBelong())) {
                    belongName = "\u4e34\u5efa";
                } else if ("1330815908893671426".equals(vo.getBelong())) {
                    belongName = "\u5408\u540c\u53ca\u8bbe\u8ba1\u53d8\u66f4";
                } else if ("1330816008898461698".equals(vo.getBelong())) {
                    belongName = "\u5b89\u5168\u6587\u660e\u65bd\u5de5";
                } else if ("1330816053479718913".equals(vo.getBelong())) {
                    belongName = "\u5176\u4ed6";
                }
                vo.setBelongName(belongName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)(vo.getBillState() == null ? 0 : vo.getBillState())).getDescription());
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("oddDetailsExport.xlsx", beans, response);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("importFlag", new Parameter("eq", (Object)0));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage pageData = this.service.queryPage(param, false);
        Map<Long, String> queryDefDoc = this.service.queryDefDoc(USE_TYPE_DEF_CODE);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), OddVO.class);
            list.forEach(vo -> {
                if (null != vo.getSourceType()) {
                    if (0 == vo.getSourceType()) {
                        vo.setSourceTypeName("\u53c2\u7167\u7533\u8bf7");
                    } else if (1 == vo.getSourceType()) {
                        vo.setSourceTypeName("\u81ea\u5236");
                    } else if (2 == vo.getSourceType()) {
                        vo.setSourceTypeName("\u4f9b\u65b9\u7533\u8bf7");
                    }
                } else {
                    vo.setSourceTypeName("");
                }
                if (null != vo.getSettleNcFlag()) {
                    if (0 == vo.getSettleNcFlag()) {
                        vo.setSettleNcFlagName("\u5426");
                    } else if (1 == vo.getSettleNcFlag()) {
                        vo.setSettleNcFlagName("\u662f");
                    }
                } else {
                    vo.setSettleNcFlagName("");
                }
                String useTypeName = "";
                if (queryDefDoc.containsKey(vo.getUseType())) {
                    useTypeName = (String)queryDefDoc.get(vo.getUseType());
                }
                vo.setUseTypeName(useTypeName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)(vo.getBillState() == null ? 0 : vo.getBillState())).getDescription());
                vo.setZkmny(vo.getZkmny() == null ? BigDecimal.ZERO : vo.getZkmny());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("odd-export.xlsx", beans, response);
    }

    @PostMapping(value={"insert"})
    @ResponseBody
    public CommonResponse<Boolean> suplInsert(@RequestBody com.ejianc.business.fbxt.odd.vo.sysupl.OddVO request) {
        return CommonResponse.success((String)"\u4f9b\u65b9\u65b0\u589e\u6570\u636e\u6210\u529f\uff01", (Object)this.service.suplInsert(request));
    }

    @PostMapping(value={"confirmSupply"})
    @ResponseBody
    public CommonResponse<Boolean> confirmSupply(@RequestBody OddVO request) {
        return CommonResponse.success((String)"\u786e\u8ba4\u6210\u529f\uff01", (Object)this.service.confirmSupply(request, BillStatusEnum.\u5df2\u786e\u8ba4.getCode()));
    }

    @PostMapping(value={"rejectSupply"})
    @ResponseBody
    public CommonResponse<Boolean> rejectSupply(@RequestBody OddVO request) {
        return CommonResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01", (Object)this.service.confirmSupply(request, BillStatusEnum.\u786e\u8ba4\u9a73\u56de.getCode()));
    }
}

