package com.ejianc.business.fbxt.odd.controller;

import java.io.Serializable;

import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.sysupl.ApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddApplyRequest;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.vo.OddApplyVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 用工申请实体
 *
 * @author generator
 */
@Controller
@RequestMapping("oddApply")
public class OddApplyController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String USE_TYPE_DEF_CODE = "fbxt-use-type";

    @Autowired
    private IOrgApi orgApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOddApplyService service;
    @Autowired
    private IOddService oddService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddApplyVO> saveOrUpdate(@RequestBody OddApplyVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddApplyVO> queryDetail(Long id) {
        OddApplyEntity entity = service.selectById(id);
        OddApplyVO vo = BeanMapper.map(entity, OddApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddApplyVO> vos) {
        service.removeByIds(vos.stream().map(OddApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage<OddApplyEntity> page = service.queryPage(param, false);
        IPage<OddApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryList 查询暂存
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryzcList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddApplyVO>> queryzcList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 0));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage<OddApplyEntity> page = service.queryPage(param, false);
        IPage<OddApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 查询暂存数量
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/getcount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> getcount(@RequestBody QueryParam param) {
        CommonResponse<IPage<OddApplyVO>> response = this.queryzcList(param);
        return CommonResponse.success("查询成功！", response.getData().getTotal());
    }

    /**
     * @Description
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryApplyRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OddApplyVO>> queryApplyRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                           @RequestParam(defaultValue = "10") Integer pageSize,
                                                           @RequestParam(value = "searchText", required = false) String searchText,
                                                           @RequestParam(value = "condition", required = false) String condition) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);

        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("cropName");
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                param.getParams().put("projectId", new Parameter("eq", conditionMap.get("projectId")));
            }
        }
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));
        param.getParams().put("registerFlag", new Parameter(QueryParam.EQ, 0));
        /** 供方已通过,不需要通过 */
        List<Integer> passFlag = new ArrayList<>();
        passFlag.add(1);
        passFlag.add(-1);
        param.getParams().put("passFlag", new Parameter(QueryParam.IN, passFlag));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage<OddApplyEntity> page = service.queryPage(param, false);
        IPage<OddApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("createTime", "desc");

        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<OddApplyEntity> pageData = service.queryPage(param, false);
        Map<Long, String> queryDefDoc = oddService.queryDefDoc(USE_TYPE_DEF_CODE);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<OddApplyVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), OddApplyVO.class);
            list.forEach(vo -> {
                if (null != vo.getRegisterFlag()) {
                    if (0 == vo.getRegisterFlag()) {
                        vo.setRegisterFlagName("否");
                    } else if (1 == vo.getRegisterFlag()) {
                        vo.setRegisterFlagName("是");
                    }
                } else {
                    vo.setRegisterFlagName("");
                }
                if (null != vo.getPassFlag()) {
                    if (-1 == vo.getPassFlag()) {
                        vo.setPassFlagName("不推送");
                    } else if (0 == vo.getPassFlag()) {
                        vo.setPassFlagName("待确认");
                    } else if (1 == vo.getPassFlag()) {
                        vo.setPassFlagName("已确认");
                    } else if (2 == vo.getPassFlag()) {
                        vo.setPassFlagName("已驳回");
                    }
                } else {
                    vo.setPassFlagName("");
                }
                String useTypeName = "";
                if (queryDefDoc.containsKey(vo.getUseType())) {
                    useTypeName = queryDefDoc.get(vo.getUseType());
                }
                vo.setUseTypeName(useTypeName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState() == null ? 0 : vo.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("apply-export.xlsx", beans, response);
    }

    /********************  同步供方相关start  **************/
    // 更新申请单是否被引用
    @PostMapping("/applyUsed")
    @ResponseBody
    public CommonResponse<Boolean> applyUsed(@RequestBody ApplyRequest request) {
        return CommonResponse.success("更新申请单是否被引用成功！", service.applyUsed(request));
    }

    /**
     * 供方确认、驳回
     *
     * @param request
     * @return
     */
    @PostMapping("/suplcommit")
    @ResponseBody
    public CommonResponse<Boolean> suplcommit(@RequestBody OddApplyRequest request) {
        return CommonResponse.success("更新申请单成功！", service.suplcommit(request));
    }
    /********************  同步供方相关end    **************/

}
