package com.ejianc.business.accplat.config.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 会计平台设置-账簿映射规则
 * 
 * @author generator
 * 
 */
@ApiModel("会计平台设置-账簿映射规则")
public class BillAccbookSetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据类型id")
    private Long billTypeId;
    @ApiModelProperty("单据类型编码")
    private String billTypeCode;
    @ApiModelProperty("单据类型")
    private String billTypeName;
    @ApiModelProperty("来源组织id")
    private Long sourceOrgId;
    @ApiModelProperty("来源组织名称")
    private String sourceOrgName;
    @ApiModelProperty("条件显示")
    private String conditionView;
    @ApiModelProperty("条件逻辑表达式")
    private String conditionExpression;
    @ApiModelProperty("目标账簿ID")
    private Long accbookId;
    @ApiModelProperty("目标账簿编码")
    private String accbookCode;
    @ApiModelProperty("目标账簿名称")
    private String accbookName;
    @ApiModelProperty("科目表")
    private Long subjectChartId;
    @ApiModelProperty("科目表")
    private String subjectChartName;
    

    /**
     * 单据类型id
     */
    @ReferSerialTransfer(referCode = "billType")
    public Long getBillTypeId() {
        return billTypeId;
    }

    /**
     * 单据类型id
     */
    @ReferDeserialTransfer
    public void setBillTypeId(Long billTypeId) {
        this.billTypeId = billTypeId;
    }
    /**
     * 单据类型编码
     */
    public String getBillTypeCode() {
        return billTypeCode;
    }

    /**
     * 单据类型编码
     */
    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }
    /**
     * 单据类型
     */
    public String getBillTypeName() {
        return billTypeName;
    }

    /**
     * 单据类型
     */
    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }
    /**
     * 来源组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getSourceOrgId() {
        return sourceOrgId;
    }

    /**
     * 来源组织id
     */
    @ReferDeserialTransfer
    public void setSourceOrgId(Long sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }
    /**
     * 来源组织名称
     */
    public String getSourceOrgName() {
        return sourceOrgName;
    }

    /**
     * 来源组织名称
     */
    public void setSourceOrgName(String sourceOrgName) {
        this.sourceOrgName = sourceOrgName;
    }
    /**
     * 条件显示
     */
    public String getConditionView() {
        return conditionView;
    }

    /**
     * 条件显示
     */
    public void setConditionView(String conditionView) {
        this.conditionView = conditionView;
    }
    /**
     * 条件逻辑表达式
     */
    public String getConditionExpression() {
        return conditionExpression;
    }

    /**
     * 条件逻辑表达式
     */
    public void setConditionExpression(String conditionExpression) {
        this.conditionExpression = conditionExpression;
    }
    /**
     * 目标账簿ID
     */
    @ReferSerialTransfer(referCode = "accplat-accbook")
    public Long getAccbookId() {
        return accbookId;
    }

    /**
     * 目标账簿ID
     */
    @ReferDeserialTransfer
    public void setAccbookId(Long accbookId) {
        this.accbookId = accbookId;
    }
    /**
     * 目标账簿编码
     */
    public String getAccbookCode() {
        return accbookCode;
    }

    /**
     * 目标账簿编码
     */
    public void setAccbookCode(String accbookCode) {
        this.accbookCode = accbookCode;
    }
    /**
     * 目标账簿名称
     */
    public String getAccbookName() {
        return accbookName;
    }

    /**
     * 目标账簿名称
     */
    public void setAccbookName(String accbookName) {
        this.accbookName = accbookName;
    }

    /**
     * 科目表
     */
    @ReferSerialTransfer(referCode = "accplat-subjectChart")
    public Long getSubjectChartId() {
        return subjectChartId;
    }

    /**
     * 科目表
     */
    @ReferDeserialTransfer
    public void setSubjectChartId(Long subjectChartId) {
        this.subjectChartId = subjectChartId;
    }

    /**
     * 科目表
     */
    public String getSubjectChartName() {
        return subjectChartName;
    }

    /**
     * 科目表
     */
    public void setSubjectChartName(String subjectChartName) {
        this.subjectChartName = subjectChartName;
    }


}
