package com.ejianc.business.accplat.consts;

/**
 * @description: AccplatConsts
 * @author songlx
 * @date 2023/12/26
 * @version 1.0
 */
public class AccplatConsts {



    /**
     * @description: 分录合并规则
     */
    public static class EntryMergeRule {

        // 暂只支持一种合并规则：科目+摘要+辅助核算项+方向一致
        public static final String SUBJECT_DESCRIPTION_AUXILIARY_DIRECTION = "subjectDescriptionAuxiliaryDirection";

    }

    /**
     * @description: 借贷方向
     */
    public static class DirectionFlag {
        // 借方
        public static final String DEBIT = "debit";
        // 贷方
        public static final String CREBIT = "crebit";

    }

    /**
     * @description: 凭证模板-分录科目规则
     */
    public static class SubjectRule {
        // 固定科目
        public static final String SUBJECT = "subject";
        // 科目分类转化
        public static final String SUBJECT_CONTRAST = "subjectContrast";

    }


    /**
     * @description: 凭证模板-摘要规则
     */
    public static class DescriptionFlag {
        // 录入
        public static final String INPUT = "input";
        // 参照常用
        public static final String REFER_USE = "referUse";
        // 单据字段
        public static final String BILL_COLUMN = "billColumn";
    }

    /**
     * @description: 字段位置
     * @author songlx
     * @date: 2023/12/28
     */
    public static class ColumnPos {
        // 主表
        public static final String H = "H";
        // 主表关联
        public static final String HR = "HR";
        // 子表
        public static final String B = "B";
    }

}
