package com.ejianc.business.accplat.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: 数据类型DataTypeEnum
 * @author songlx
 * @date 2023/12/4
 * @version 1.0
 */
public enum DataTypeEnum {


    基础档案(1, "基础档案"),

    自定义档案(2, "自定义档案"),

    布尔(3, "布尔"),

    枚举(4, "枚举"),

    文本(5, "文本");

    private static Map<Integer, DataTypeEnum> enumMap = new HashMap();

    static {
        enumMap = EnumSet.allOf(DataTypeEnum.class).stream().collect(Collectors.toMap(DataTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }


    public static String getNameByCode(Integer code) {
        return enumMap.get(code) != null ? enumMap.get(code).getName() : "未定义";
    }


    private Integer code;

    private String name;


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    DataTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
}
