package com.ejianc.business.accplat.originvoucher.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 原始凭证
 *
 * @author generator
 *
 */
@ApiModel("原始凭证")
public class OriginVoucherVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源单据类型ID")
    private Long srcBillTypeId;
    @ApiModelProperty("来源单据类型编码")
    private String srcBillTypeCode;
    @ApiModelProperty("来源单据类型名称")
    private String srcBillTypeName;
    @ApiModelProperty("来源系统编码")
    private String srcSystemCode;
    @ApiModelProperty("来源系统名称")
    private String srcSystemName;
    @ApiModelProperty("来源业务单据ID")
    private Long srcBillId;
    @ApiModelProperty("来源业务单据编码")
    private String srcBillCode;
    @ApiModelProperty("来源业务单据URL-PC")
    private String srcBillPcUrl;
    @ApiModelProperty("来源业务单据主组织ID")
    private Long srcBillOrgId;
    @ApiModelProperty("来源业务单据主组织编码 ")
    private String srcBillOrgCode;
    @ApiModelProperty("来源业务单据主组织名称")
    private String srcBillOrgName;
    @ApiModelProperty("凭证生成时间")
    private Date voucherCreateTime;
    @ApiModelProperty("凭证日期")
    private Date voucherDate;
    @ApiModelProperty("业务日期")
    private Date businessDate;
    @ApiModelProperty("制单人ID")
    private Long markerId;
    @ApiModelProperty("制单人编码")
    private String markerCode;
    @ApiModelProperty("制单人名称")
    private String markerName;
    @ApiModelProperty("原始凭证展示编号")
    private String voucherCode;
    @ApiModelProperty("凭证类型编码")
    private String voucherTypeCode;
    @ApiModelProperty("凭证类型名称")
    private String voucherTypeName;
    @ApiModelProperty("借方金额合计")
    private BigDecimal debitTotalMny;
    @ApiModelProperty("贷方金额合计")
    private BigDecimal creditTotalMny;
    @ApiModelProperty("摘要")
    private String description;
    @ApiModelProperty("账簿ID")
    private Long accbookId;
    @ApiModelProperty("账簿编号")
    private String accbookCode;
    @ApiModelProperty("账簿名称")
    private String accbookName;
    @ApiModelProperty("生成财务凭证状态")
    private Integer financeVoucherFlag;
    @ApiModelProperty("财务凭证ID")
    private String financeVoucherId;
    @ApiModelProperty("财务凭证号")
    private String financeVoucherCode;
    @ApiModelProperty("生成财务凭证回参")
    private String financeVoucherInfo;
    @ApiModelProperty("目标财务系统标识")
    private String financeSystemCode;
    @ApiModelProperty("转换模版ID")
    private Long voucherTemplateId;

    @ApiModelProperty("原始凭证分录")
    private List<OriginVoucherEntryVO> originVoucherEntryList = new ArrayList<>();

    /**
     * 来源单据类型ID
     */
    public Long getSrcBillTypeId() {
        return srcBillTypeId;
    }

    /**
     * 来源单据类型ID
     */
    public void setSrcBillTypeId(Long srcBillTypeId) {
        this.srcBillTypeId = srcBillTypeId;
    }

    /**
     * 来源单据类型编码
     */
    public String getSrcBillTypeCode() {
        return srcBillTypeCode;
    }

    /**
     * 来源单据类型编码
     */
    public void setSrcBillTypeCode(String srcBillTypeCode) {
        this.srcBillTypeCode = srcBillTypeCode;
    }

    /**
     * 来源单据类型名称
     */
    public String getSrcBillTypeName() {
        return srcBillTypeName;
    }

    /**
     * 来源单据类型名称
     */
    public void setSrcBillTypeName(String srcBillTypeName) {
        this.srcBillTypeName = srcBillTypeName;
    }

    /**
     * 来源系统编码
     */
    public String getSrcSystemCode() {
        return srcSystemCode;
    }

    /**
     * 来源系统编码
     */
    public void setSrcSystemCode(String srcSystemCode) {
        this.srcSystemCode = srcSystemCode;
    }

    /**
     * 来源系统名称
     */
    public String getSrcSystemName() {
        return srcSystemName;
    }

    /**
     * 来源系统名称
     */
    public void setSrcSystemName(String srcSystemName) {
        this.srcSystemName = srcSystemName;
    }

    /**
     * 来源业务单据ID
     */
    public Long getSrcBillId() {
        return srcBillId;
    }

    /**
     * 来源业务单据ID
     */
    public void setSrcBillId(Long srcBillId) {
        this.srcBillId = srcBillId;
    }

    /**
     * 来源业务单据编码
     */
    public String getSrcBillCode() {
        return srcBillCode;
    }

    /**
     * 来源业务单据编码
     */
    public void setSrcBillCode(String srcBillCode) {
        this.srcBillCode = srcBillCode;
    }

    /**
     * 来源业务单据URL-PC
     */
    public String getSrcBillPcUrl() {
        return srcBillPcUrl;
    }

    /**
     * 来源业务单据URL-PC
     */
    public void setSrcBillPcUrl(String srcBillPcUrl) {
        this.srcBillPcUrl = srcBillPcUrl;
    }

    /**
     * 来源业务单据主组织ID
     */
    public Long getSrcBillOrgId() {
        return srcBillOrgId;
    }

    /**
     * 来源业务单据主组织ID
     */
    public void setSrcBillOrgId(Long srcBillOrgId) {
        this.srcBillOrgId = srcBillOrgId;
    }

    /**
     * 来源业务单据主组织编码 
     */
    public String getSrcBillOrgCode() {
        return srcBillOrgCode;
    }

    /**
     * 来源业务单据主组织编码 
     */
    public void setSrcBillOrgCode(String srcBillOrgCode) {
        this.srcBillOrgCode = srcBillOrgCode;
    }

    /**
     * 来源业务单据主组织名称
     */
    public String getSrcBillOrgName() {
        return srcBillOrgName;
    }

    /**
     * 来源业务单据主组织名称
     */
    public void setSrcBillOrgName(String srcBillOrgName) {
        this.srcBillOrgName = srcBillOrgName;
    }

    /**
     * 凭证生成时间
     */
    public Date getVoucherCreateTime() {
        return voucherCreateTime;
    }

    /**
     * 凭证生成时间
     */
    public void setVoucherCreateTime(Date voucherCreateTime) {
        this.voucherCreateTime = voucherCreateTime;
    }

    /**
     * 凭证日期
     */
    public Date getVoucherDate() {
        return voucherDate;
    }

    /**
     * 凭证日期
     */
    public void setVoucherDate(Date voucherDate) {
        this.voucherDate = voucherDate;
    }

    /**
     * 业务日期
     */
    public Date getBusinessDate() {
        return businessDate;
    }

    /**
     * 业务日期
     */
    public void setBusinessDate(Date businessDate) {
        this.businessDate = businessDate;
    }

    /**
     * 制单人ID
     */
    public Long getMarkerId() {
        return markerId;
    }

    /**
     * 制单人ID
     */
    public void setMarkerId(Long markerId) {
        this.markerId = markerId;
    }

    /**
     * 制单人编码
     */
    public String getMarkerCode() {
        return markerCode;
    }

    /**
     * 制单人编码
     */
    public void setMarkerCode(String markerCode) {
        this.markerCode = markerCode;
    }

    /**
     * 制单人名称
     */
    public String getMarkerName() {
        return markerName;
    }

    /**
     * 制单人名称
     */
    public void setMarkerName(String markerName) {
        this.markerName = markerName;
    }

    /**
     * 原始凭证展示编号
     */
    public String getVoucherCode() {
        return voucherCode;
    }

    /**
     * 原始凭证展示编号
     */
    public void setVoucherCode(String voucherCode) {
        this.voucherCode = voucherCode;
    }

    /**
     * 凭证类型编码
     */
    public String getVoucherTypeCode() {
        return voucherTypeCode;
    }

    /**
     * 凭证类型编码
     */
    public void setVoucherTypeCode(String voucherTypeCode) {
        this.voucherTypeCode = voucherTypeCode;
    }

    /**
     * 凭证类型名称
     */
    public String getVoucherTypeName() {
        return voucherTypeName;
    }

    /**
     * 凭证类型名称
     */
    public void setVoucherTypeName(String voucherTypeName) {
        this.voucherTypeName = voucherTypeName;
    }

    /**
     * 借方金额合计
     */
    public BigDecimal getDebitTotalMny() {
        return debitTotalMny;
    }

    /**
     * 借方金额合计
     */
    public void setDebitTotalMny(BigDecimal debitTotalMny) {
        this.debitTotalMny = debitTotalMny;
    }

    /**
     * 贷方金额合计
     */
    public BigDecimal getCreditTotalMny() {
        return creditTotalMny;
    }

    /**
     * 贷方金额合计
     */
    public void setCreditTotalMny(BigDecimal creditTotalMny) {
        this.creditTotalMny = creditTotalMny;
    }

    /**
     * 摘要
     */
    public String getDescription() {
        return description;
    }

    /**
     * 摘要
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 账簿ID
     */
    public Long getAccbookId() {
        return accbookId;
    }

    /**
     * 账簿ID
     */
    public void setAccbookId(Long accbookId) {
        this.accbookId = accbookId;
    }

    /**
     * 账簿编号
     */
    public String getAccbookCode() {
        return accbookCode;
    }

    /**
     * 账簿编号
     */
    public void setAccbookCode(String accbookCode) {
        this.accbookCode = accbookCode;
    }

    /**
     * 账簿名称
     */
    public String getAccbookName() {
        return accbookName;
    }

    /**
     * 账簿名称
     */
    public void setAccbookName(String accbookName) {
        this.accbookName = accbookName;
    }

    /**
     * 生成财务凭证状态
     */
    public Integer getFinanceVoucherFlag() {
        return financeVoucherFlag;
    }

    /**
     * 生成财务凭证状态
     */
    public void setFinanceVoucherFlag(Integer financeVoucherFlag) {
        this.financeVoucherFlag = financeVoucherFlag;
    }

    /**
     * 财务凭证ID
     */
    public String getFinanceVoucherId() {
        return financeVoucherId;
    }

    /**
     * 财务凭证ID
     */
    public void setFinanceVoucherId(String financeVoucherId) {
        this.financeVoucherId = financeVoucherId;
    }

    /**
     * 财务凭证号
     */
    public String getFinanceVoucherCode() {
        return financeVoucherCode;
    }

    /**
     * 财务凭证号
     */
    public void setFinanceVoucherCode(String financeVoucherCode) {
        this.financeVoucherCode = financeVoucherCode;
    }

    /**
     * 生成财务凭证回参
     */
    public String getFinanceVoucherInfo() {
        return financeVoucherInfo;
    }

    /**
     * 生成财务凭证回参
     */
    public void setFinanceVoucherInfo(String financeVoucherInfo) {
        this.financeVoucherInfo = financeVoucherInfo;
    }

    /**
     * 目标财务系统标识
     */
    public String getFinanceSystemCode() {
        return financeSystemCode;
    }

    /**
     * 目标财务系统标识
     */
    public void setFinanceSystemCode(String financeSystemCode) {
        this.financeSystemCode = financeSystemCode;
    }

    /**
     * 转换模版ID
     */
    public Long getVoucherTemplateId() {
        return voucherTemplateId;
    }

    /**
     * 转换模版ID
     */
    public void setVoucherTemplateId(Long voucherTemplateId) {
        this.voucherTemplateId = voucherTemplateId;
    }

    /**
     * 原始凭证分录
     */
    public List<OriginVoucherEntryVO> getOriginVoucherEntryList() {
        return originVoucherEntryList;
    }

    /**
     * 原始凭证分录
     */
    public void setOriginVoucherEntryList(List<OriginVoucherEntryVO> originVoucherEntryList) {
        this.originVoucherEntryList = originVoucherEntryList;
    }
}
