package com.ejianc.business.voucher.utils;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @description: DataConvertUtil
 * @author songlx
 * @date 2023/12/15
 * @version 1.0
 */
@Slf4j
public class DataConvertUtil {

    private static Gson gson;

    private static JsonParser jsonParser;

    // 字段正则表达式，用于获取公式中的字段
    private static String COLUMN_PATTERN = "[A-Za-z_.]{2,}";

    // 忽略正则匹配下的来的不是字段的字符(AviatorUtil自定义的函数等)
    private static List<String> ignoreColumnList = new ArrayList<>();

    static {
        gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").setLongSerializationPolicy(LongSerializationPolicy.STRING).setPrettyPrinting().create();
        jsonParser = new JsonParser();

        ignoreColumnList.addAll(Arrays.asList(AviatorUtil.SELF_FUNC_ARR));
    }


    public static String objToString(Object obj) {
        return gson.toJson(obj);
    }


    public static Map<String, Object> objToMap(Object obj) {
        Type type = new TypeToken<Map<String, Object>>() {
        }.getType();
        return JSONObject.parseObject(objToString(obj), type);
    }


    public static <T> T stringToObj(String text, Class<T> clazz) {
        return JSONObject.parseObject(text, clazz);
    }

    public static String toPrettyFormat(Object obj) {
        if (obj instanceof String) {
            return gson.toJson(jsonParser.parse(String.valueOf(obj)).getAsJsonObject());
        }
        return objToString(obj);

    }


    public static String formatDate(Object date) {
        if (date instanceof Date) {
            return DateUtil.formatDate((Date) date);
        }
        return date.toString().substring(0, 10);
    }

    static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");


    public static Date getDate(Object date) {
        Date da = null;
        if (date instanceof Date) {
            da = (Date) date;
        } else {
            try {
                Date newTime = format.parse(date.toString().substring(0, 10));
                da = newTime;
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return da;
    }


    /**
     * 获取表达式中的关联字段和子表字段以便特殊解析处理
     */
    public static List<String> getRelaionOrSubColumnList(String exprsss) {
        Set<String> relaionOrSubColumnSet = new HashSet();
        Pattern p = Pattern.compile(COLUMN_PATTERN);
        Matcher m = p.matcher(exprsss);
        while (m.find()) {
            String column = m.group();
            if (!ignoreColumnList.contains(column) && column.contains(".")) {
                relaionOrSubColumnSet.add(column);
            }
        }
        log.info(">>>>>>获取表达式中的关联字段和子表字段：表达式：{}，关联OR子表字段：{}", exprsss, relaionOrSubColumnSet);
        return relaionOrSubColumnSet.stream().collect(Collectors.toList());
    }


    public static void main(String[] args) {
        String columnExpression = "_projectId.id + '_' + pay.code + billCode +list._peojectId.id + CONTAIN(pay.code, '你好') + NOT_CONTAIN(pay.code, '你好')";
        getRelaionOrSubColumnList(columnExpression);

    }


}
