/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.utils;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ejianc.business.voucher.utils.AviatorUtil;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(DataConvertUtil.class);
    private static Gson gson;
    private static JsonParser jsonParser;
    private static String COLUMN_PATTERN;
    private static List<String> ignoreColumnList;
    static SimpleDateFormat format;

    public static String objToString(Object obj) {
        return gson.toJson(obj);
    }

    public static Map<String, Object> objToMap(Object obj) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)JSONObject.parseObject((String)DataConvertUtil.objToString(obj), (Type)type, (Feature[])new Feature[0]);
    }

    public static <T> T stringToObj(String text, Class<T> clazz) {
        return (T)JSONObject.parseObject((String)text, clazz);
    }

    public static String toPrettyFormat(Object obj) {
        if (obj instanceof String) {
            return gson.toJson((JsonElement)jsonParser.parse(String.valueOf(obj)).getAsJsonObject());
        }
        return DataConvertUtil.objToString(obj);
    }

    public static String formatDate(Object date) {
        if (date instanceof Date) {
            return DateUtil.formatDate((Date)((Date)date));
        }
        return date.toString().substring(0, 10);
    }

    public static Date getDate(Object date) {
        Date da = null;
        if (date instanceof Date) {
            da = (Date)date;
        } else {
            try {
                Date newTime;
                da = newTime = format.parse(date.toString().substring(0, 10));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return da;
    }

    public static List<String> getRelaionOrSubColumnList(String exprsss) {
        HashSet<String> relaionOrSubColumnSet = new HashSet<String>();
        Pattern p = Pattern.compile(COLUMN_PATTERN);
        Matcher m = p.matcher(exprsss);
        while (m.find()) {
            String column = m.group();
            if (ignoreColumnList.contains(column) || !column.contains(".")) continue;
            relaionOrSubColumnSet.add(column);
        }
        log.info(">>>>>>\u83b7\u53d6\u8868\u8fbe\u5f0f\u4e2d\u7684\u5173\u8054\u5b57\u6bb5\u548c\u5b50\u8868\u5b57\u6bb5\uff1a\u8868\u8fbe\u5f0f\uff1a{}\uff0c\u5173\u8054OR\u5b50\u8868\u5b57\u6bb5\uff1a{}", (Object)exprsss, relaionOrSubColumnSet);
        return relaionOrSubColumnSet.stream().collect(Collectors.toList());
    }

    public static void main(String[] args) {
        String columnExpression = "_projectId.id + '_' + pay.code + billCode +list._peojectId.id + CONTAIN(pay.code, '\u4f60\u597d') + NOT_CONTAIN(pay.code, '\u4f60\u597d')";
        DataConvertUtil.getRelaionOrSubColumnList(columnExpression);
        System.out.println(IdWorker.getId());
    }

    static {
        COLUMN_PATTERN = "[A-Za-z_.]{2,}";
        ignoreColumnList = new ArrayList<String>();
        gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").setLongSerializationPolicy(LongSerializationPolicy.STRING).setPrettyPrinting().create();
        jsonParser = new JsonParser();
        ignoreColumnList.addAll(Arrays.asList(AviatorUtil.SELF_FUNC_ARR));
        format = new SimpleDateFormat("yyyy-MM-dd");
    }
}

