package com.ejianc.business.accplat.config.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 账簿
 *
 * @author generator
 *
 */
@ApiModel("账簿")
public class AccbookVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("账簿编码")
    private String code;
    @ApiModelProperty("账簿名称")
    private String name;
    @ApiModelProperty("科目表")
    private Long subjectChartId;
    @ApiModelProperty("科目表")
    private String subjectChartName;
    @ApiModelProperty("启用状态1启用0停用")
    private Integer enabled;


    private String enabledName;
    private String errMsg;

    /**
     * 账簿编码
     */
    public String getCode() {
        return code;
    }

    /**
     * 账簿编码
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 账簿名称
     */
    public String getName() {
        return name;
    }

    /**
     * 账簿名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 科目表
     */
    @ReferSerialTransfer(referCode = "accplat-subjectChart")
    public Long getSubjectChartId() {
        return subjectChartId;
    }

    /**
     * 科目表
     */
    @ReferDeserialTransfer
    public void setSubjectChartId(Long subjectChartId) {
        this.subjectChartId = subjectChartId;
    }

    /**
     * 科目表
     */
    public String getSubjectChartName() {
        return subjectChartName;
    }

    /**
     * 科目表
     */
    public void setSubjectChartName(String subjectChartName) {
        this.subjectChartName = subjectChartName;
    }


    /**
     * 启用状态1启用0停用
     */
    public Integer getEnabled() {
        return enabled;
    }

    /**
     * 启用状态1启用0停用
     */
    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
        this.enabledName = enabled.intValue() == 1 ? "启用" : "停用";

    }

    public String getEnabledName() {
        return enabledName;
    }

    public void setEnabledName(String enabledName) {
        this.enabledName = enabledName;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

}
