package com.ejianc.business.accplat.config.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 会计平台设置-辅助核算项关联
 * 
 * @author generator
 * 
 */
@ApiModel("会计平台设置-辅助核算项关联")
public class BillAuxiliarySetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据类型id")
    private Long billTypeId;
    @ApiModelProperty("单据类型编码")
    private String billTypeCode;
    @ApiModelProperty("单据类型")
    private String billTypeName;
    @ApiModelProperty("辅助核算项id")
    private Long auxiliaryId;
    @ApiModelProperty("辅助核算项编码")
    private String auxiliaryCode;
    @ApiModelProperty("辅助核算项名称")
    private String auxiliaryName;
    @ApiModelProperty("档案id")
    private Long referId;
    @ApiModelProperty("档案参照编码")
    private String referCode;
    @ApiModelProperty("档案参照名称")
    private String referName;
    @ApiModelProperty("数据类型1基础档案2自定义档案")
    private Integer dataType;
    @ApiModelProperty("字段显示")
    private String columnView;
    @ApiModelProperty("字段表达式")
    private String columnExpression;

    @ApiModelProperty(value="字段id")
    private Long columnId;

    @ApiModelProperty(value="字段名")
    private String columnName;

    @ApiModelProperty(value="字段位置:H主表、HR主表关联、B子表、BR子表关联")
    private String columnPos;

    public String getColumnPos() {
        return columnPos;
    }

    public void setColumnPos(String columnPos) {
        this.columnPos = columnPos;
    }

    @ReferSerialTransfer(referCode = "md-attribute")
    public Long getColumnId() {
        return columnId;
    }
    @ReferDeserialTransfer
    public void setColumnId(Long columnId) {
        this.columnId = columnId;
    }

    public String getColumnName() {
        return columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    /**
     * 单据类型id
     */
    @ReferSerialTransfer(referCode = "billType")
    public Long getBillTypeId() {
        return billTypeId;
    }

    /**
     * 单据类型id
     */
    @ReferDeserialTransfer
    public void setBillTypeId(Long billTypeId) {
        this.billTypeId = billTypeId;
    }
    /**
     * 单据类型编码
     */
    public String getBillTypeCode() {
        return billTypeCode;
    }

    /**
     * 单据类型编码
     */
    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }
    /**
     * 单据类型
     */
    public String getBillTypeName() {
        return billTypeName;
    }

    /**
     * 单据类型
     */
    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }
    /**
     * 辅助核算项id
     */
    @ReferSerialTransfer(referCode = "accplat-auxiliary")
    public Long getAuxiliaryId() {
        return auxiliaryId;
    }

    /**
     * 辅助核算项id
     */
    @ReferDeserialTransfer
    public void setAuxiliaryId(Long auxiliaryId) {
        this.auxiliaryId = auxiliaryId;
    }
    /**
     * 辅助核算项编码
     */
    public String getAuxiliaryCode() {
        return auxiliaryCode;
    }

    /**
     * 辅助核算项编码
     */
    public void setAuxiliaryCode(String auxiliaryCode) {
        this.auxiliaryCode = auxiliaryCode;
    }
    /**
     * 辅助核算项名称
     */
    public String getAuxiliaryName() {
        return auxiliaryName;
    }

    /**
     * 辅助核算项名称
     */
    public void setAuxiliaryName(String auxiliaryName) {
        this.auxiliaryName = auxiliaryName;
    }
    /**
     * 档案id
     */
    public Long getReferId() {
        return referId;
    }

    /**
     * 档案id
     */
    public void setReferId(Long referId) {
        this.referId = referId;
    }
    /**
     * 档案参照编码
     */
    public String getReferCode() {
        return referCode;
    }

    /**
     * 档案参照编码
     */
    public void setReferCode(String referCode) {
        this.referCode = referCode;
    }
    /**
     * 档案参照名称
     */
    public String getReferName() {
        return referName;
    }

    /**
     * 档案参照名称
     */
    public void setReferName(String referName) {
        this.referName = referName;
    }
    /**
     * 数据类型1基础档案2自定义档案
     */
    public Integer getDataType() {
        return dataType;
    }

    /**
     * 数据类型1基础档案2自定义档案
     */
    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }
    /**
     * 字段显示
     */
    public String getColumnView() {
        return columnView;
    }

    /**
     * 字段显示
     */
    public void setColumnView(String columnView) {
        this.columnView = columnView;
    }
    /**
     * 字段表达式
     */
    public String getColumnExpression() {
        return columnExpression;
    }

    /**
     * 字段表达式
     */
    public void setColumnExpression(String columnExpression) {
        this.columnExpression = columnExpression;
    }
    
}
