package com.ejianc.business.accplat.originvoucher.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 凭证模板
 * 
 * @author generator
 * 
 */
@ApiModel("凭证模板")
public class VoucherTemplateVO extends BaseVO {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty("模板编码")
    private String templateCode;
    @ApiModelProperty("账簿ID")
    private Long accbookId;
    @ApiModelProperty("账簿编号")
    private String accbookCode;
    @ApiModelProperty("账簿名称")
    private String accbookName;
    @ApiModelProperty("科目表")
    private Long subjectChartId;
    @ApiModelProperty("科目表")
    private String subjectChartName;
    @ApiModelProperty("分录是否合并规则")
    private String entryMergeRule;
    @ApiModelProperty("金额为空是否过滤")
    private Boolean mnyNullFilterFlag;
    @ApiModelProperty("来源单据类型ID")
    private Long srcBillTypeId;
    @ApiModelProperty("来源单据类型编码")
    private String srcBillTypeCode;
    @ApiModelProperty("来源单据类型名称")
    private String srcBillTypeName;
    @ApiModelProperty("凭证类型ex01:记账")
    private String voucherType;
    @ApiModelProperty("汇率类型")
    private String rateType;
    @ApiModelProperty("币别")
    private String currencyCode;
    @ApiModelProperty("制单人ID取值字段")
    private String markerColumn;
    @ApiModelProperty("业务日期取值字段")
    private String businessDateColumn;
    @ApiModelProperty("来源单据URL")
    private String srcBillPcUrl;
    @ApiModelProperty("来源单据主组织字段名")
    private String srcBillOrgColumn;
    @ApiModelProperty("业务类型,依据此参数细分单据类型模板")
    private String businessType;
    
    @ApiModelProperty("凭证模板明细")
    private List<VoucherTemplateDetailVO> voucherTemplateDetailList = new ArrayList<>();


    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    /**
     * 科目表
     */
    @ReferSerialTransfer(referCode = "accplat-subjectChart")
    public Long getSubjectChartId() {
        return subjectChartId;
    }

    /**
     * 科目表
     */
    @ReferDeserialTransfer
    public void setSubjectChartId(Long subjectChartId) {
        this.subjectChartId = subjectChartId;
    }

    /**
     * 科目表
     */
    public String getSubjectChartName() {
        return subjectChartName;
    }

    /**
     * 科目表
     */
    public void setSubjectChartName(String subjectChartName) {
        this.subjectChartName = subjectChartName;
    }


    /**
     * 账簿ID
     */
    @ReferSerialTransfer(referCode = "accplat-accbook")
    public Long getAccbookId() {
        return accbookId;
    }

    /**
     * 账簿ID
     */
    @ReferDeserialTransfer
    public void setAccbookId(Long accbookId) {
        this.accbookId = accbookId;
    }
    /**
     * 账簿编号
     */
    public String getAccbookCode() {
        return accbookCode;
    }

    /**
     * 账簿编号
     */
    public void setAccbookCode(String accbookCode) {
        this.accbookCode = accbookCode;
    }
    /**
     * 账簿名称
     */
    public String getAccbookName() {
        return accbookName;
    }

    /**
     * 账簿名称
     */
    public void setAccbookName(String accbookName) {
        this.accbookName = accbookName;
    }
    /**
     * 分录是否合并规则
     */
    public String getEntryMergeRule() {
        return entryMergeRule;
    }

    /**
     * 分录是否合并规则
     */
    public void setEntryMergeRule(String entryMergeRule) {
        this.entryMergeRule = entryMergeRule;
    }
    /**
     * 金额为空是否过滤
     */
    public Boolean getMnyNullFilterFlag() {
        return mnyNullFilterFlag;
    }

    /**
     * 金额为空是否过滤
     */
    public void setMnyNullFilterFlag(Boolean mnyNullFilterFlag) {
        this.mnyNullFilterFlag = mnyNullFilterFlag;
    }
    /**
     * 来源单据类型ID
     */
    @ReferSerialTransfer(referCode = "billType")
    public Long getSrcBillTypeId() {
        return srcBillTypeId;
    }

    /**
     * 来源单据类型ID
     */
    @ReferDeserialTransfer
    public void setSrcBillTypeId(Long srcBillTypeId) {
        this.srcBillTypeId = srcBillTypeId;
    }
    /**
     * 来源单据类型编码
     */
    public String getSrcBillTypeCode() {
        return srcBillTypeCode;
    }

    /**
     * 来源单据类型编码
     */
    public void setSrcBillTypeCode(String srcBillTypeCode) {
        this.srcBillTypeCode = srcBillTypeCode;
    }
    /**
     * 来源单据类型名称
     */
    public String getSrcBillTypeName() {
        return srcBillTypeName;
    }

    /**
     * 来源单据类型名称
     */
    public void setSrcBillTypeName(String srcBillTypeName) {
        this.srcBillTypeName = srcBillTypeName;
    }
    /**
     * 凭证类型ex01:记账
     */
    public String getVoucherType() {
        return voucherType;
    }

    /**
     * 凭证类型ex01:记账
     */
    public void setVoucherType(String voucherType) {
        this.voucherType = voucherType;
    }
    /**
     * 汇率类型
     */
    public String getRateType() {
        return rateType;
    }

    /**
     * 汇率类型
     */
    public void setRateType(String rateType) {
        this.rateType = rateType;
    }
    /**
     * 币别
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /**
     * 币别
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }
    /**
     * 业务日期取值字段
     */
    public String getMarkerColumn() {
        return markerColumn;
    }

    /**
     * 业务日期取值字段
     */
    public void setMarkerColumn(String markerColumn) {
        this.markerColumn = markerColumn;
    }
    /**
     * 凭证类型ex01:记账
     */
    public String getBusinessDateColumn() {
        return businessDateColumn;
    }

    /**
     * 凭证类型ex01:记账
     */
    public void setBusinessDateColumn(String businessDateColumn) {
        this.businessDateColumn = businessDateColumn;
    }
    /**
     * 来源单据URL
     */
    public String getSrcBillPcUrl() {
        return srcBillPcUrl;
    }

    /**
     * 来源单据URL
     */
    public void setSrcBillPcUrl(String srcBillPcUrl) {
        this.srcBillPcUrl = srcBillPcUrl;
    }
    /**
     * 来源单据主组织字段名
     */
    public String getSrcBillOrgColumn() {
        return srcBillOrgColumn;
    }

    /**
     * 来源单据主组织字段名
     */
    public void setSrcBillOrgColumn(String srcBillOrgColumn) {
        this.srcBillOrgColumn = srcBillOrgColumn;
    }
    
     /**
      * 凭证模板明细
      */
      public List<VoucherTemplateDetailVO> getVoucherTemplateDetailList() {
         return voucherTemplateDetailList;
      }
     /**
      * 凭证模板明细
      */
     public void setVoucherTemplateDetailList(List<VoucherTemplateDetailVO> voucherTemplateDetailList) {
         this.voucherTemplateDetailList = voucherTemplateDetailList;
     }
}
