package com.ejianc.business.voucher.utils;

import com.ejianc.framework.core.util.ComputeUtil;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @description: AviatorUtil
 * @author songlx
 * @date 2023/12/22
 * @version 1.0
 */
@Slf4j
public class AviatorUtil {

    public static final String ADD = "+";

    public static final String AND = "&&";

    public static final String OR = "||";

    // 自定义函数名注册数组
    public static final String[] SELF_FUNC_ARR = {"CONTAIN"};

    static {
        initSelfFunction();
    }

    /**
     * 覆盖==符号，全部转成字符串来相等比较，以扩展适配性
     */
    private static void initSelfFunction() {
   /*     AviatorEvaluator.addOpFunction(OperatorType.EQ, new AbstractFunction() {
            @Override
            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                Object v1 = FunctionUtils.getJavaObject(arg1, env);
                String v2;
                if (arg2 instanceof AviatorNumber) {
                    Long numberValue = FunctionUtils.getNumberValue(arg2, env).longValue();
                    v2 = String.valueOf(numberValue);
                } else {
                    v2 = FunctionUtils.getStringValue(arg2, env);
                }
                return AviatorBoolean.valueOf(String.valueOf(v1).equals(v2));
            }

            @Override
            public String getName() {
                return "==";
            }
        });*/
        AviatorEvaluator.addOpFunction(OperatorType.ADD, new AbstractFunction() {
            @Override
            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                Object v1 = FunctionUtils.getNumberValue(arg1, env);
                Object v2 = FunctionUtils.getNumberValue(arg2, env);
                BigDecimal bigDecimal = ComputeUtil.safeAdd(ComputeUtil.toBigDecimal(v1), ComputeUtil.toBigDecimal(v2));
                return AviatorDecimal.valueOf(bigDecimal);
            }
            @Override
            public String getName() {
                return OperatorType.ADD.getToken();
            }
        });
        AviatorEvaluator.addOpFunction(OperatorType.SUB, new AbstractFunction() {
            @Override
            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                Object v1 = FunctionUtils.getNumberValue(arg1, env);
                Object v2 = FunctionUtils.getNumberValue(arg2, env);
                BigDecimal bigDecimal = ComputeUtil.safeSub(ComputeUtil.toBigDecimal(v1), ComputeUtil.toBigDecimal(v2));
                return AviatorDecimal.valueOf(bigDecimal);
            }
            @Override
            public String getName() {
                return OperatorType.SUB.getToken();
            }
        });
        AviatorEvaluator.addFunction(new CONTAIN());
    }

    /**
     * 自定义函数-包含
     * CONTAIN(a,b)  a包含b
     */
    public static class CONTAIN extends AbstractFunction {
        @Override
        public AviatorBoolean call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
            String v1 = FunctionUtils.getStringValue(arg1, env);
            String v2;
            if (arg2 instanceof AviatorNumber) {
                Long numberValue = FunctionUtils.getNumberValue(arg2, env).longValue();
                v2 = String.valueOf(numberValue);
            } else {
                v2 = FunctionUtils.getStringValue(arg2, env);
            }
            return AviatorBoolean.valueOf(v1.contains(v2));
        }

        public String getName() {
            return SELF_FUNC_ARR[0];
        }
    }

    public static boolean execCONTAIN(String key, Object val, Map map) {
        return exec("CONTAIN(" + key + ", " + val + ")", map);
    }


    public static <T> T exec(String express, Map map) {
        Object res = AviatorEvaluator.execute(express, map, true);
        log.info("--------------执行表达式：{}，结果：{}", express, res);
        return (T) res;
    }


    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("projectId.id1", "1234");
        map.put("a", new BigDecimal("2"));
        map.put("b", null);
        HashMap<String, Object> map1 = new HashMap<>();
        map1.put("id", 234.0000);
        map.put("projectId", map1);
        Object exec = exec(" a-1-b ", map);
        System.out.println(exec);
    }


}

