package com.ejianc.business.accplat.config.vo;

import com.ejianc.business.accplat.consts.DataTypeEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 影响因素
 * 
 * @author generator
 * 
 */
@ApiModel("影响因素")
public class InfluenceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("名称")
    private String name;
    @ApiModelProperty("档案id")
    private Long referId;
    @ApiModelProperty("档案参照编码")
    private String referCode;
    @ApiModelProperty("档案参照名称")
    private String referName;
    @ApiModelProperty("数据类型1基础档案2自定义档案")
    private Integer dataType;
    @ApiModelProperty(value="数据格式，自定义枚举")
    private String dataFormat;
    @ApiModelProperty("业务描述")
    private String memo;

    public String getDataFormat() {
        return dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    private String dataTypeName;

    /**
     * 名称
     */
    public String getName() {
        return name;
    }

    /**
     * 名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 档案id
     */
    public Long getReferId() {
        return referId;
    }

    /**
     * 档案id
     */
    public void setReferId(Long referId) {
        this.referId = referId;
    }
    /**
     * 档案参照编码
     */
    public String getReferCode() {
        return referCode;
    }

    /**
     * 档案参照编码
     */
    public void setReferCode(String referCode) {
        this.referCode = referCode;
    }
    /**
     * 档案参照名称
     */
    public String getReferName() {
        return referName;
    }

    /**
     * 档案参照名称
     */
    public void setReferName(String referName) {
        this.referName = referName;
    }
    /**
     * 数据类型1基础档案2自定义档案
     */
    public Integer getDataType() {
        return dataType;
    }

    /**
     * 数据类型1基础档案2自定义档案
     */
    public void setDataType(Integer dataType) {
        this.dataType = dataType;
        this.dataTypeName = DataTypeEnum.getNameByCode(dataType);
    }


    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getDataTypeName() {
        return dataTypeName;
    }

    public void setDataTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
    }
}
