package com.ejianc.business.accplat.config.vo;

import com.ejianc.business.accplat.consts.DataTypeEnum;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 辅助核算项
 * 
 * @author generator
 * 
 */
@ApiModel("辅助核算项")
public class AuxiliaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("编码")
    private String auxiliaryCode;
    @ApiModelProperty("名称")
    private String auxiliaryName;
    @ApiModelProperty("档案id")
    private Long referId;
    @ApiModelProperty("档案参照编码")
    private String referCode;
    @ApiModelProperty("档案参照名称")
    private String referName;
    @ApiModelProperty("数据类型1基础档案2自定义档案")
    private Integer dataType;
    @ApiModelProperty(value="enabled")
    private Integer enabled; // 启用状态1启用0停用

    private String dataTypeName;

    private String enabledName;

    @ApiModelProperty("对照数据id")
    private Long compareAppId;
    @ApiModelProperty("对照数据编码")
    private String compareAppName;

    @ReferSerialTransfer(referCode = "idm-system-app")
    public Long getCompareAppId() {
        return compareAppId;
    }

    @ReferDeserialTransfer
    public void setCompareAppId(Long compareAppId) {
        this.compareAppId = compareAppId;
    }

    public String getCompareAppName() {
        return compareAppName;
    }

    public void setCompareAppName(String compareAppName) {
        this.compareAppName = compareAppName;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
        this.enabledName = enabled.intValue() == 1 ? "启用" : "停用";
    }

    /**
     * 编码
     */
    public String getAuxiliaryCode() {
        return auxiliaryCode;
    }

    /**
     * 编码
     */
    public void setAuxiliaryCode(String auxiliaryCode) {
        this.auxiliaryCode = auxiliaryCode;
    }
    /**
     * 名称
     */
    public String getAuxiliaryName() {
        return auxiliaryName;
    }

    /**
     * 名称
     */
    public void setAuxiliaryName(String auxiliaryName) {
        this.auxiliaryName = auxiliaryName;
    }

    /**
     * 档案id
     */
    public Long getReferId() {
        return referId;
    }

    /**
     * 档案id
     */
    public void setReferId(Long referId) {
        this.referId = referId;
    }
    /**
     * 档案参照编码
     */
    public String getReferCode() {
        return referCode;
    }

    /**
     * 档案参照编码
     */
    public void setReferCode(String referCode) {
        this.referCode = referCode;
    }
    /**
     * 档案参照名称
     */
    public String getReferName() {
        return referName;
    }

    /**
     * 档案参照名称
     */
    public void setReferName(String referName) {
        this.referName = referName;
    }
    /**
     * 数据类型1基础档案2自定义档案
     */
    public Integer getDataType() {
        return dataType;
    }

    /**
     * 数据类型1基础档案2自定义档案
     */
    public void setDataType(Integer dataType) {
        this.dataType = dataType;
        this.dataTypeName = DataTypeEnum.getNameByCode(dataType);

    }

    public String getEnabledName() {
        return enabledName;
    }

    public void setEnabledName(String enabledName) {
        this.enabledName = enabledName;
    }


    public String getDataTypeName() {
        return dataTypeName;
    }

    public void setDataTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
    }
}
