package com.ejianc.business.accplat.config.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 科目对照
 * 
 * @author generator
 * 
 */
@ApiModel("科目对照")
public class SubjectContrastVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("科目表ID")
    private Long subjectChartId;
    @ApiModelProperty("科目表编码")
    private String subjectChartCode;
    @ApiModelProperty("科目表名称")
    private String subjectChartName;
    @ApiModelProperty("科目分类编码")
    private String subjectCategoryCode;
    @ApiModelProperty("科目分类名称")
    private String subjectCategoryName;
    @ApiModelProperty("默认入账科目ID")
    private Long defaultSubjectId;
    @ApiModelProperty("默认入账科目编码")
    private String defaultSubjectCode;
    @ApiModelProperty("默认入账科目名称")
    private String defaultSubjectName;
    @ApiModelProperty("影响因素ids")
    private String influenceIds;
    @ApiModelProperty("影响因素names")
    private String influenceNames;
    
    @ApiModelProperty("科目对照-对照明细")
    private List<SubjectContrastDetailVO> subjectContrastDetailList = new ArrayList<>();

    //已选择的影响因素
    private List<InfluenceVO> selectedInfluence = new ArrayList<>();

    public List<InfluenceVO> getSelectedInfluence() {
        return selectedInfluence;
    }

    public void setSelectedInfluence(List<InfluenceVO> selectedInfluence) {
        this.selectedInfluence = selectedInfluence;
    }

    /**
     * 科目表ID
     */
    @ReferSerialTransfer(referCode = "accplat-subjectChart")
    public Long getSubjectChartId() {
        return subjectChartId;
    }

    /**
     * 科目表ID
     */
    @ReferDeserialTransfer
    public void setSubjectChartId(Long subjectChartId) {
        this.subjectChartId = subjectChartId;
    }
    /**
     * 科目表编码
     */
    public String getSubjectChartCode() {
        return subjectChartCode;
    }

    /**
     * 科目表编码
     */
    public void setSubjectChartCode(String subjectChartCode) {
        this.subjectChartCode = subjectChartCode;
    }
    /**
     * 科目表名称
     */
    public String getSubjectChartName() {
        return subjectChartName;
    }

    /**
     * 科目表名称
     */
    public void setSubjectChartName(String subjectChartName) {
        this.subjectChartName = subjectChartName;
    }
    /**
     * 科目分类编码
     */
    public String getSubjectCategoryCode() {
        return subjectCategoryCode;
    }

    /**
     * 科目分类编码
     */
    public void setSubjectCategoryCode(String subjectCategoryCode) {
        this.subjectCategoryCode = subjectCategoryCode;
    }
    /**
     * 科目分类名称
     */
    public String getSubjectCategoryName() {
        return subjectCategoryName;
    }

    /**
     * 科目分类名称
     */
    public void setSubjectCategoryName(String subjectCategoryName) {
        this.subjectCategoryName = subjectCategoryName;
    }
    /**
     * 默认入账科目ID
     */
    @ReferSerialTransfer(referCode = "accplat-subject")
    public Long getDefaultSubjectId() {
        return defaultSubjectId;
    }

    /**
     * 默认入账科目ID
     */
    @ReferDeserialTransfer
    public void setDefaultSubjectId(Long defaultSubjectId) {
        this.defaultSubjectId = defaultSubjectId;
    }
    /**
     * 默认入账科目编码
     */
    public String getDefaultSubjectCode() {
        return defaultSubjectCode;
    }

    /**
     * 默认入账科目编码
     */
    public void setDefaultSubjectCode(String defaultSubjectCode) {
        this.defaultSubjectCode = defaultSubjectCode;
    }
    /**
     * 默认入账科目名称
     */
    public String getDefaultSubjectName() {
        return defaultSubjectName;
    }

    /**
     * 默认入账科目名称
     */
    public void setDefaultSubjectName(String defaultSubjectName) {
        this.defaultSubjectName = defaultSubjectName;
    }
    /**
     * 影响因素ids
     */
    @ReferSerialTransfer(referCode = "accplat-influence")
    public String getInfluenceIds() {
        return influenceIds;
    }

    /**
     * 影响因素ids
     */
    @ReferDeserialTransfer
    public void setInfluenceIds(String influenceIds) {
        this.influenceIds = influenceIds;
    }
    /**
     * 影响因素names
     */
    public String getInfluenceNames() {
        return influenceNames;
    }

    /**
     * 影响因素names
     */
    public void setInfluenceNames(String influenceNames) {
        this.influenceNames = influenceNames;
    }
    
     /**
      * 科目对照-对照明细
      */
      public List<SubjectContrastDetailVO> getSubjectContrastDetailList() {
         return subjectContrastDetailList;
      }
     /**
      * 科目对照-对照明细
      */
     public void setSubjectContrastDetailList(List<SubjectContrastDetailVO> subjectContrastDetailList) {
         this.subjectContrastDetailList = subjectContrastDetailList;
     }
}
