package com.ejianc.business.voucher.utils;

import java.util.*;

/**
 * @description: ResultAsTreePlus
 * @author songlx
 * @date 2023/12/20
 * @version 1.0
 */
public class ResultAsTreePlus {

    public ResultAsTreePlus() {
    }

    public static List<Map<String, Object>> createTreeData(List<Map> list) {
        List<Map<String, Object>> resp = new ArrayList();
        List<String> rootItems = new ArrayList();
        Map<String, Map<String, Object>> listMap = new HashMap();
        Iterator var4 = list.iterator();

        Map item;
        while(var4.hasNext()) {
            item = (Map)var4.next();
            listMap.put(item.get("id").toString(), item);
        }

        for(int i = 0; i < list.size(); ++i) {
            item = (Map)list.get(i);
            String parentId = item.get("parentId") != null ? item.get("parentId").toString() : "";
            Map<String, Object> parent = (Map)listMap.get(parentId);
            if (parent != null) {
                item.put("parentCode", parent.get("subjectCode"));
                item.put("parentName", parent.get("subjectName"));
                List<Map<String, Object>> child = (List)parent.get("children");
                if (child != null) {
                    child.add(item);
                } else {
                    List<Map<String, Object>> children = new ArrayList();
                    children.add(item);
                    parent.put("children", children);
                }
            } else {
                rootItems.add(item.get("id").toString());
            }
        }

        var4 = rootItems.iterator();

        while(var4.hasNext()) {
            String rootId = (String)var4.next();
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
