package com.ejianc.business.voucher.vo;

import com.ejianc.business.accplat.config.vo.BillAccbookSetVO;
import com.ejianc.business.accplat.config.vo.BillVoucherSetVO;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.exception.BusinessException;
import lombok.Data;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;


/**
 * @description: YSVoucherInfo 凭证简化信息，直接保存在业务单据
 * @author songlx
 * @date 2023/11/21
 * @version 1.0
 */
@Data
public class VoucherParams extends BaseVoucher {

    // 业务单据编码
    private String billCode;

    // 业务单据主组织id
    private Long orgId;

    // 业务单据id
    private Long billId;

    // 业务单据数据
    private Map<String, Object> billData;

    private String srcSystemCode;

    private String srcSystemName;


    // 原始凭证
    private List<OriginVoucherVO> originVoucherVOList = new LinkedList<>();


    // 财务凭证参数，推送财务系统生成真正的凭证
    private Map<String, Object> financeVoucher;

    // 是否生成原始凭证标识
    private Boolean isGenerateOriginVoucherFlag;

    // 是否生成财务凭证标识
    private Boolean isGenerateFinanceVoucherFlag;


    // 传凭证设置
    private BillVoucherSetVO billVoucherSetVO;

    // 所有符合条件的账簿设置，有可能传多个账簿、多个凭证
    private List<BillAccbookSetVO> billAccbookSetVOList;

    //单据类型VO
    private BillTypeVO billTypeVO;


    /**
     * 业务类型扩展
     * 正常依据单据类型只能设置一个凭证模板，扩展业务类型根据业务类型设置多个模板，businessType值
     * 例如：合同付款申请，可以根据合同类型扩展
     */
    private String businessType;


    /**
     * 无需传凭证放置的一些信息
     */
    private String msgInfo;

    /**
     * @description: 根据单据类型和单据数据快速构建凭证参数
     *
     * @param billTypeCode 单据类型
     * @param billData 单据数据
     * @return {@link VoucherParams}
     * @author songlx
     * @date: 2023/12/19
     */
    public static VoucherParams newInstance(String billTypeCode, Long orgId, String billCode, Object billData, SystemCodeEnum systemCodeEnum) {
        return new VoucherParams(billTypeCode, orgId, billCode, DataConvertUtil.objToMap(billData), null, systemCodeEnum);
    }

    public static VoucherParams newInstance(String billTypeCode, Long orgId, String billCode, Object billData, String businessType, SystemCodeEnum systemCodeEnum) {
        return new VoucherParams(billTypeCode, orgId, billCode, DataConvertUtil.objToMap(billData), businessType, systemCodeEnum);
    }


    public static VoucherParams newInstanceByOrgId(String billTypeCode, Object billData, String businessType, SystemCodeEnum systemCodeEnum) {
        Map<String, Object> billMap = DataConvertUtil.objToMap(billData);
        Object orgIdObj = billMap.get("orgId");
        if(orgIdObj == null){
            throw new BusinessException("newInstanceByOrgId：没有orgId字段值");
        }
        Long orgId = Long.valueOf(orgIdObj.toString());
        return new VoucherParams(billTypeCode, orgId, null, billMap, businessType, systemCodeEnum);
    }

    public static VoucherParams newInstanceByOrgId(String billTypeCode, Object billData, SystemCodeEnum systemCodeEnum) {
        Map<String, Object> billMap = DataConvertUtil.objToMap(billData);
        Object orgIdObj = billMap.get("orgId");
        if(orgIdObj == null){
            throw new BusinessException("newInstanceByOrgId：没有orgId字段值");
        }
        Long orgId = Long.valueOf(orgIdObj.toString());
        return new VoucherParams(billTypeCode, orgId, null, billMap, null, systemCodeEnum);
    }


    public VoucherParams(String billTypeCode, Long orgId, String billCode, Map<String, Object> billData, String businessType, SystemCodeEnum systemCodeEnum) {
        this.setBillTypeCode(billTypeCode);
        this.billData = billData;
        this.orgId = orgId;
        this.billCode = billCode;
        this.businessType = businessType;
        this.srcSystemCode = systemCodeEnum.getCode();
        this.srcSystemName = systemCodeEnum.getName();
    }

    public VoucherParams() {
    }
}
