package com.ejianc.business.accplat.config.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 会计平台设置-影响因素关联
 * 
 * @author generator
 * 
 */
@ApiModel("会计平台设置-影响因素关联")
public class BillInfluenceSetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据类型id")
    private Long billTypeId;
    @ApiModelProperty("单据类型编码")
    private String billTypeCode;
    @ApiModelProperty("单据类型")
    private String billTypeName;
    @ApiModelProperty("影响因素id")
    private Long influenceId;
    @ApiModelProperty("影响因素name")
    private String influenceName;
    @ApiModelProperty("数据类型1基础档案2自定义档案")
    private Integer dataType;
    @ApiModelProperty("字段显示")
    private String columnView;
    @ApiModelProperty("字段表达式")
    private String columnExpression;

    @ApiModelProperty(value="字段id")
    private Long columnId;

    @ApiModelProperty(value="字段名")
    private String columnName;

    @ApiModelProperty(value="字段位置:H主表、HR主表关联、B子表、BR子表关联")
    private String columnPos;

    public Integer getDataType() {
        return dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public String getColumnPos() {
        return columnPos;
    }

    public void setColumnPos(String columnPos) {
        this.columnPos = columnPos;
    }

    @ReferSerialTransfer(referCode = "md-attribute")
    public Long getColumnId() {
        return columnId;
    }
    @ReferDeserialTransfer
    public void setColumnId(Long columnId) {
        this.columnId = columnId;
    }

    public String getColumnName() {
        return columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    /**
     * 单据类型id
     */
    @ReferSerialTransfer(referCode = "billType")
    public Long getBillTypeId() {
        return billTypeId;
    }

    /**
     * 单据类型id
     */
    @ReferDeserialTransfer
    public void setBillTypeId(Long billTypeId) {
        this.billTypeId = billTypeId;
    }
    /**
     * 单据类型编码
     */
    public String getBillTypeCode() {
        return billTypeCode;
    }

    /**
     * 单据类型编码
     */
    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }
    /**
     * 单据类型
     */
    public String getBillTypeName() {
        return billTypeName;
    }

    /**
     * 单据类型
     */
    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }
    /**
     * 影响因素id
     */
    @ReferSerialTransfer(referCode = "accplat-influence")
    public Long getInfluenceId() {
        return influenceId;
    }

    /**
     * 影响因素id
     */
    @ReferDeserialTransfer
    public void setInfluenceId(Long influenceId) {
        this.influenceId = influenceId;
    }
    /**
     * 影响因素name
     */
    public String getInfluenceName() {
        return influenceName;
    }

    /**
     * 影响因素name
     */
    public void setInfluenceName(String influenceName) {
        this.influenceName = influenceName;
    }
    /**
     * 字段显示
     */
    public String getColumnView() {
        return columnView;
    }

    /**
     * 字段显示
     */
    public void setColumnView(String columnView) {
        this.columnView = columnView;
    }
    /**
     * 字段表达式
     */
    public String getColumnExpression() {
        return columnExpression;
    }

    /**
     * 字段表达式
     */
    public void setColumnExpression(String columnExpression) {
        this.columnExpression = columnExpression;
    }
    
}
