package com.ejianc.business.accplat.config.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;


/**
 * 科目对照-对照明细
 * 
 * @author generator
 * 
 */
@ApiModel("科目对照-对照明细")
public class SubjectContrastDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主表ID")
    private Long contrastId;
    @ApiModelProperty("入账科目ID")
    private Long accountSubjectId;
    @ApiModelProperty("入账科目编码")
    private String accountSubjectCode;
    @ApiModelProperty("入账科目名称")
    private String accountSubjectName;
    @ApiModelProperty("序号")
    private Integer sequence;


    @ApiModelProperty("科目对照-对照明细影响因素值")
    private List<SubjectContrastDetailInfluenceVO> subjectContrastDetailInfluenceList = new ArrayList<>();



    public List<SubjectContrastDetailInfluenceVO> getSubjectContrastDetailInfluenceList() {
        return subjectContrastDetailInfluenceList;
    }

    public void setSubjectContrastDetailInfluenceList(List<SubjectContrastDetailInfluenceVO> subjectContrastDetailInfluenceList) {
        this.subjectContrastDetailInfluenceList = subjectContrastDetailInfluenceList;
    }

    /**
     * 主表ID
     */
    public Long getContrastId() {
        return contrastId;
    }

    /**
     * 主表ID
     */
    public void setContrastId(Long contrastId) {
        this.contrastId = contrastId;
    }

    @ReferSerialTransfer(referCode = "accplat-subject")
    public Long getAccountSubjectId() {
        return accountSubjectId;
    }

    @ReferDeserialTransfer
    public void setAccountSubjectId(Long accountSubjectId) {
        this.accountSubjectId = accountSubjectId;
    }

    public String getAccountSubjectCode() {
        return accountSubjectCode;
    }

    public void setAccountSubjectCode(String accountSubjectCode) {
        this.accountSubjectCode = accountSubjectCode;
    }

    public String getAccountSubjectName() {
        return accountSubjectName;
    }

    public void setAccountSubjectName(String accountSubjectName) {
        this.accountSubjectName = accountSubjectName;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
}
