package com.ejianc.business.accplat.config.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 会计科目
 * 
 * @author generator
 * 
 */
@ApiModel("会计科目")
public class SubjectVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("父ID")
    private Long parentId;
    @ApiModelProperty("父ID集合")
    private String innerCode;
    @ApiModelProperty("科目表ID")
    private Long subjectChartId;
    @ApiModelProperty("序号")
    private String treeIndex;
    @ApiModelProperty("科目编码")
    private String subjectCode;
    @ApiModelProperty("科目名称")
    private String subjectName;
    @ApiModelProperty("全名")
    private String fullName;
    @ApiModelProperty("辅助核算项ids")
    private String auxiliaryIds;
    @ApiModelProperty("辅助核算项names")
    private String auxiliaryNames;
    @ApiModelProperty("会计科目-辅助核算项")
    private List<SubjectAuxiliaryVO> subjectAuxiliaryList = new ArrayList<>();


    @ApiModelProperty("导入errMsg")
    private String errMsg;
    @ApiModelProperty("辅助核算项names(导入错误信息显示用)")
    private String auxiliaryNamesImport;

    private List<SubjectVO> children;


    public List<SubjectVO> getChildren() {
        return children;
    }

    public void setChildren(List<SubjectVO> children) {
        this.children = children;
    }

    public String getAuxiliaryNamesImport() {
        return auxiliaryNamesImport;
    }

    public void setAuxiliaryNamesImport(String auxiliaryNamesImport) {
        this.auxiliaryNamesImport = auxiliaryNamesImport;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    /**
     * 父ID
     */
    @ReferSerialTransfer(referCode = "accplat-subject")
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    @ReferDeserialTransfer
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 父ID集合
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 父ID集合
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    /**
     * 科目表ID
     */
    public Long getSubjectChartId() {
        return subjectChartId;
    }

    /**
     * 科目表ID
     */
    public void setSubjectChartId(Long subjectChartId) {
        this.subjectChartId = subjectChartId;
    }
    /**
     * 科目编码
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 科目编码
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    /**
     * 科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    /**
     * 全名
     */
    public String getFullName() {
        return fullName;
    }

    /**
     * 全名
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }
    /**
     * 辅助核算项ids
     */
    public String getAuxiliaryIds() {
        return auxiliaryIds;
    }

    /**
     * 辅助核算项ids
     */
    public void setAuxiliaryIds(String auxiliaryIds) {
        this.auxiliaryIds = auxiliaryIds;
    }
    /**
     * 辅助核算项names
     */
    public String getAuxiliaryNames() {
        return auxiliaryNames;
    }

    /**
     * 辅助核算项names
     */
    public void setAuxiliaryNames(String auxiliaryNames) {
        this.auxiliaryNames = auxiliaryNames;
    }
    
     /**
      * 会计科目-辅助核算项
      */
      public List<SubjectAuxiliaryVO> getSubjectAuxiliaryList() {
         return subjectAuxiliaryList;
      }
     /**
      * 会计科目-辅助核算项
      */
     public void setSubjectAuxiliaryList(List<SubjectAuxiliaryVO> subjectAuxiliaryList) {
         this.subjectAuxiliaryList = subjectAuxiliaryList;
     }
}
