package com.ejianc.business.accplat.originvoucher.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 原始凭证分录
 *
 * @author generator
 *
 */
@ApiModel("原始凭证分录")
public class OriginVoucherEntryVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("原始凭证ID")
    private Long originVoucherId;
    @ApiModelProperty("分录摘要")
    private String entryDescription;
    @ApiModelProperty("科目ID")
    private Long subjectId;
    @ApiModelProperty("科目编码")
    private String subjectCode;
    @ApiModelProperty("科目名称")
    private String subjectName;
    @ApiModelProperty("辅助核算项ids")
    private String auxiliaryIds;
    @ApiModelProperty("辅助核算项展示信息")
    private String auxiliaryInfo;
    @ApiModelProperty("借方原币金额")
    private BigDecimal debitOriginalMny;
    @ApiModelProperty("贷方原币金额")
    private BigDecimal creditOriginalMny;
    @ApiModelProperty("借贷方向debit借credit贷")
    private String directionFlag;
    @ApiModelProperty("汇率类型")
    private String rateType;
    @ApiModelProperty("币别")
    private String currencyCode;

    @ApiModelProperty("币别名称")
    private String currencyName;

    private List<OriginVoucherAuxiliaryVO> originVoucherAuxiliaryVOList = new ArrayList<>(); // 原始凭证分录核算项


    public String getCurrencyName() {
        return currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public String getAuxiliaryIds() {
        return auxiliaryIds;
    }

    public void setAuxiliaryIds(String auxiliaryIds) {
        this.auxiliaryIds = auxiliaryIds;
    }

    /**
     * 原始凭证ID
     */
    public Long getOriginVoucherId() {
        return originVoucherId;
    }

    /**
     * 原始凭证ID
     */
    public void setOriginVoucherId(Long originVoucherId) {
        this.originVoucherId = originVoucherId;
    }

    /**
     * 分录摘要
     */
    public String getEntryDescription() {
        return entryDescription;
    }

    /**
     * 分录摘要
     */
    public void setEntryDescription(String entryDescription) {
        this.entryDescription = entryDescription;
    }

    /**
     * 科目ID
     */
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 科目ID
     */
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    /**
     * 科目编码
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 科目编码
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    /**
     * 科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    /**
     * 辅助核算项展示信息
     */
    public String getAuxiliaryInfo() {
        return auxiliaryInfo;
    }

    /**
     * 辅助核算项展示信息
     */
    public void setAuxiliaryInfo(String auxiliaryInfo) {
        this.auxiliaryInfo = auxiliaryInfo;
    }

    /**
     * 借方原币金额
     */
    public BigDecimal getDebitOriginalMny() {
        return debitOriginalMny;
    }

    /**
     * 借方原币金额
     */
    public void setDebitOriginalMny(BigDecimal debitOriginalMny) {
        this.debitOriginalMny = debitOriginalMny;
    }

    /**
     * 贷方原币金额
     */
    public BigDecimal getCreditOriginalMny() {
        return creditOriginalMny;
    }

    /**
     * 贷方原币金额
     */
    public void setCreditOriginalMny(BigDecimal creditOriginalMny) {
        this.creditOriginalMny = creditOriginalMny;
    }

    /**
     * 借贷方向debit借credit贷
     */
    public String getDirectionFlag() {
        return directionFlag;
    }

    /**
     * 借贷方向debit借credit贷
     */
    public void setDirectionFlag(String directionFlag) {
        this.directionFlag = directionFlag;
    }

    /**
     * 汇率类型
     */
    public String getRateType() {
        return rateType;
    }

    /**
     * 汇率类型
     */
    public void setRateType(String rateType) {
        this.rateType = rateType;
    }

    /**
     * 币别
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /**
     * 币别
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }


    public List<OriginVoucherAuxiliaryVO> getOriginVoucherAuxiliaryVOList() {
        return originVoucherAuxiliaryVOList;
    }

    public void setOriginVoucherAuxiliaryVOList(List<OriginVoucherAuxiliaryVO> originVoucherAuxiliaryVOList) {
        this.originVoucherAuxiliaryVOList = originVoucherAuxiliaryVOList;
    }

    public static OriginVoucherEntryVO getInstanceVO(String directionFlag, Long subjectId, String subjectCode, String subjectName) {
        return new OriginVoucherEntryVO(directionFlag, subjectId, subjectCode, subjectName);
    }


    public OriginVoucherEntryVO(String directionFlag, Long subjectId, String subjectCode, String subjectName) {
        this.directionFlag = directionFlag;
        this.subjectId = subjectId;
        this.subjectCode = subjectCode;
        this.subjectName = subjectName;
    }

    public OriginVoucherEntryVO() {
    }
}
