package com.ejianc.business.voucher.api;


import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.voucher.hystrix.VoucherHystrix;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @description: 凭证IVoucherApi
 *
 * @author songlx
 * @date: 2023/11/21
 */
@FeignClient(name = "ejc-accplat-web", url = "${common.env.feign-client-url}", path = "ejc-accplat-web", fallback = VoucherHystrix.class)
public interface IVoucherApi {

    /**
     * 凭证综合业务处理入口
     */
    @RequestMapping(value = "/api/voucherApi/handleVoucher", method = RequestMethod.POST)
    CommonResponse<VoucherInfo> handleVoucher(@RequestBody VoucherParams voucherParams, @RequestParam("voucherOptFlag") String voucherOptFlag);

    /**
     * 保存凭证
     */
    @RequestMapping(value = "/api/voucherApi/save", method = RequestMethod.POST)
    CommonResponse<VoucherInfo> save(@RequestBody VoucherParams voucherParams);


    /**
     * 查询凭证
     */
    @RequestMapping(value = "/api/voucherApi/get", method = RequestMethod.POST)
    CommonResponse<List<OriginVoucherVO>> get(@RequestBody VoucherInfo voucherInfo);


    /**
     * 删除凭证
     */
    @RequestMapping(value = "/api/voucherApi/del", method = RequestMethod.POST)
    CommonResponse<String> del(@RequestBody VoucherInfo voucherInfo);

}
