package com.ejianc.business.voucher.callable;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.Date;
import java.util.concurrent.Callable;

/**
 * @description: AccplatVoucherCallable
 * @author songlx
 * @date 2024/1/12
 * @version 1.0
 */
public class AccplatVoucherCallable<T> implements Callable<CommonResponse> {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private IVoucherApi voucherApi;

    private IBaseService<T> billService;
    private VoucherParams voucherParams;
    private String voucherOptFlag;
    private RequestAttributes context;
    private String authority;

    public AccplatVoucherCallable(IVoucherApi voucherApi, IBaseService<T> billService, VoucherParams voucherParams, String voucherOptFlag, RequestAttributes context, String authority) {
        this.voucherApi = voucherApi;
        this.billService = billService;
        this.voucherParams = voucherParams;
        this.voucherOptFlag = voucherOptFlag;
        this.context = context;
        this.authority = authority;
    }

    @Override
    public CommonResponse<VoucherInfo> call() {
        logger.info("-----{}--动作{}--线程开始{}----------------", this.getClass(), voucherOptFlag, DateUtil.formatDateTime(new Date()));
        RequestContextHolder.setRequestAttributes(context);
        InvocationInfoProxy.setExtendAttribute("authority", authority);
        CommonResponse<VoucherInfo> response = voucherApi.handleVoucher(voucherParams, voucherOptFlag);
        VoucherInfo voucherInfoRes = response.getData();
        Long billId = voucherInfoRes.getBillId();
        UpdateWrapper<T> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", billId);
        String voucherInfoStr = DataConvertUtil.objToString(voucherInfoRes);
        updateWrapper.set("voucher_flag", voucherInfoRes.getVoucherFlag());
        updateWrapper.set("voucher_info", voucherInfoStr);
        billService.update(updateWrapper);
        logger.info("---------结果：{}", DataConvertUtil.toPrettyFormat(response));
        logger.info("-----{}--动作{}--线程结束{}----------------", this.getClass(), voucherOptFlag, DateUtil.formatDateTime(new Date()));
        return response;
    }
}
