package com.ejianc.business.voucher.callable;

import cn.hutool.core.date.DateUtil;
import com.ejianc.business.voucher.service.IVoucherService;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.Date;
import java.util.concurrent.Callable;

/**
 * @description: VoucherCallable
 * @author songlx
 * @date 2024/1/12
 * @version 1.0
 */
public class VoucherCallable<T> implements Callable<CommonResponse> {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private IVoucherService voucherService;
    private T billVO;
    private String voucherOptFlag;
    private RequestAttributes context;
    private String authority;

    public VoucherCallable(IVoucherService voucherService, String voucherOptFlag, T billVO, RequestAttributes context, String authority) {
        this.voucherService = voucherService;
        this.billVO = billVO;
        this.voucherOptFlag = voucherOptFlag;
        this.context = context;
        this.authority = authority;
    }

    @Override
    public CommonResponse<VoucherInfo> call() {
        logger.info("------{}--VoucherCallable线程开始-------{}---------", DateUtil.formatDateTime(new Date()), voucherOptFlag);
        RequestContextHolder.setRequestAttributes(context);
        InvocationInfoProxy.setExtendAttribute("authority", authority);
        CommonResponse<VoucherInfo> response = voucherService.handleVoucher(billVO, voucherOptFlag);
        logger.info("-----{}--VoucherCallable线程结果：{}", this.getClass(), DataConvertUtil.toPrettyFormat(response));
        logger.info("-----{}--VoucherCallable线程结束-------{}---------", DateUtil.formatDateTime(new Date()), voucherOptFlag);
        return response;
    }
}
