package com.ejianc.business.voucher.vo;

import com.ejianc.business.voucher.consts.VoucherFlag;
import lombok.Data;

import java.util.Arrays;
import java.util.List;


/**
 * @description: YSVoucherInfo 凭证简化信息，直接保存在业务单据
 * @author songlx
 * @date 2023/11/21
 * @version 1.0
 */
@Data
public class VoucherInfo extends BaseVoucher {

    private Long billId;


    // 用于更新业务单据voucherFlag
    private Integer voucherFlag;


    // 凭证数据
    private List<VoucherSimpleVO> vouchers;

    /**
     * 无需传凭证放置的一些信息或者成功响应需要说明的一些描述信息
     */
    private String msgInfo;

    /**
     * @description: 凭证成功快速构建
     */
    public static VoucherInfo getVoucherInfo(VoucherSimpleVO voucherSimpleVO) {
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setVoucherFlag(VoucherFlag.SUCCESS);
        voucherInfo.setVouchers(Arrays.asList(voucherSimpleVO));
        return voucherInfo;
    }

    public static VoucherInfo getVoucherInfo(List<VoucherSimpleVO> voucherSimpleVOs) {
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setVoucherFlag(VoucherFlag.SUCCESS);
        voucherInfo.setVouchers(voucherSimpleVOs);
        return voucherInfo;
    }


    /**
     * @description: 不需要传凭证成功快速构建
     */
    public static VoucherInfo getNoNeedVoucherInfo(String msgInfo) {
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setVoucherFlag(VoucherFlag.NO_NEED);
        voucherInfo.setMsgInfo(msgInfo);
        return voucherInfo;
    }
}
