/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.callable;

import cn.hutool.core.date.DateUtil;
import com.ejianc.business.voucher.service.IVoucherService;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Date;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class VoucherCallable<T>
implements Callable<CommonResponse> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IVoucherService voucherService;
    private T billVO;
    private String voucherOptFlag;
    private RequestAttributes context;
    private String authority;

    public VoucherCallable(IVoucherService voucherService, String voucherOptFlag, T billVO, RequestAttributes context, String authority) {
        this.voucherService = voucherService;
        this.billVO = billVO;
        this.voucherOptFlag = voucherOptFlag;
        this.context = context;
        this.authority = authority;
    }

    @Override
    public CommonResponse<VoucherInfo> call() {
        this.logger.info("------{}--VoucherCallable\u7ebf\u7a0b\u5f00\u59cb-------{}---------", (Object)DateUtil.formatDateTime((Date)new Date()), (Object)this.voucherOptFlag);
        RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)this.authority);
        CommonResponse response = this.voucherService.handleVoucher(this.billVO, this.voucherOptFlag);
        this.logger.info("-----{}--VoucherCallable\u7ebf\u7a0b\u7ed3\u679c\uff1a{}", this.getClass(), (Object)DataConvertUtil.toPrettyFormat(response));
        this.logger.info("-----{}--VoucherCallable\u7ebf\u7a0b\u7ed3\u675f-------{}---------", (Object)DateUtil.formatDateTime((Date)new Date()), (Object)this.voucherOptFlag);
        return response;
    }
}

