/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.callable;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class AccplatVoucherAggCallable<T>
implements Callable<CommonResponse> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IVoucherApi voucherApi;
    private IBaseService<T> billService;
    private IBaseService<T> subService;
    private VoucherParams voucherParams;
    private List<VoucherParams> subParams;
    private String voucherOptFlag;
    private RequestAttributes context;
    private String authority;

    public AccplatVoucherAggCallable(IVoucherApi voucherApi, IBaseService<T> billService, IBaseService<T> subService, VoucherParams voucherParams, List<VoucherParams> subParams, String voucherOptFlag, RequestAttributes context, String authority) {
        this.voucherApi = voucherApi;
        this.billService = billService;
        this.voucherParams = voucherParams;
        this.subService = subService;
        this.subParams = subParams;
        this.voucherOptFlag = voucherOptFlag;
        this.context = context;
        this.authority = authority;
    }

    @Override
    public CommonResponse<VoucherInfo> call() {
        UpdateWrapper updateWrapper;
        String billTypeCode = this.voucherParams.getBillTypeCode();
        Map<String, Object> billData = this.voucherParams.getBillData();
        this.logger.info("-----\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a{}--\u52a8\u4f5c{}--\u7ebf\u7a0b\u5f00\u59cb{}----------------", new Object[]{billTypeCode, this.voucherOptFlag, DateUtil.formatDateTime((Date)new Date())});
        RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)this.authority);
        CommonResponse<VoucherInfo> response = this.voucherApi.handleVoucher(this.voucherParams, this.voucherOptFlag);
        Long billId = null;
        if (response.getData() != null) {
            VoucherInfo voucherInfoRes = (VoucherInfo)response.getData();
            billId = voucherInfoRes.getBillId();
            if (billId != null) {
                updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"id", (Object)billId);
                String voucherInfoStr = DataConvertUtil.objToString(voucherInfoRes);
                updateWrapper.set((Object)"voucher_flag", (Object)voucherInfoRes.getVoucherFlag());
                updateWrapper.set((Object)"voucher_info", (Object)voucherInfoStr);
                this.billService.update((Wrapper)updateWrapper);
            }
        } else {
            Object id = billData.get("id");
            if (id != null) {
                billId = Long.valueOf(String.valueOf(id));
                updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"id", (Object)billId);
                updateWrapper.set((Object)"voucher_flag", (Object)VoucherFlag.FAILED);
                updateWrapper.set((Object)"voucher_info", (Object)response.getMsg());
                this.billService.update((Wrapper)updateWrapper);
            }
        }
        if (response != null && response.isSuccess() && CollectionUtils.isNotEmpty(this.subParams)) {
            for (VoucherParams params : this.subParams) {
                UpdateWrapper updateWrapper2;
                CommonResponse<VoucherInfo> subResponse = this.voucherApi.handleVoucher(params, this.voucherOptFlag);
                Long subbillId = null;
                if (subResponse.getData() != null) {
                    VoucherInfo voucherInfoRes = (VoucherInfo)subResponse.getData();
                    subbillId = voucherInfoRes.getBillId();
                    if (subbillId == null) continue;
                    updateWrapper2 = new UpdateWrapper();
                    updateWrapper2.eq((Object)"id", (Object)subbillId);
                    String voucherInfoStr = DataConvertUtil.objToString(voucherInfoRes);
                    updateWrapper2.set((Object)"voucher_flag", (Object)voucherInfoRes.getVoucherFlag());
                    updateWrapper2.set((Object)"voucher_info", (Object)voucherInfoStr);
                    this.billService.update((Wrapper)updateWrapper2);
                    continue;
                }
                Object id = billData.get("id");
                if (id == null) continue;
                subbillId = Long.valueOf(String.valueOf(id));
                updateWrapper2 = new UpdateWrapper();
                updateWrapper2.eq((Object)"id", (Object)subbillId);
                updateWrapper2.set((Object)"voucher_flag", (Object)VoucherFlag.FAILED);
                updateWrapper2.set((Object)"voucher_info", (Object)subResponse.getMsg());
                this.billService.update((Wrapper)updateWrapper2);
            }
        }
        this.logger.info("-----\u5355\u636eID\uff1a{}--\u7ed3\u679c\uff1a{}", (Object)billId, (Object)DataConvertUtil.toPrettyFormat(response));
        this.logger.info("-----\u5355\u636eID\uff1a{}--\u52a8\u4f5c{}--\u7ebf\u7a0b\u7ed3\u675f{}----------------", new Object[]{billId, this.voucherOptFlag, DateUtil.formatDateTime((Date)new Date())});
        return response;
    }
}

