package com.ejianc.foundation.ai.utils;

import java.util.concurrent.*;

public class ThreadPoolUtils {

	
	private ThreadPoolExecutor executors = null;
	
	private ThreadPoolUtils() {
		executors = new ThreadPoolExecutor(100, 500, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(500));
	}

	private static class ThreadPoolUtilsHolder{
		private static ThreadPoolUtils instance = new ThreadPoolUtils();
	}

	public static ThreadPoolUtils getInstance() {
		return ThreadPoolUtilsHolder.instance;
	}
	
	public Future<String> runTask(Callable<String> callable) {
		try{
			return executors.submit(callable);
		}catch(Exception e){}
		return null;
	}

}
