package com.ejianc.foundation.ai.api;

import com.ejianc.foundation.ai.hystrix.MaterialMaterialAiHystrix;
import com.ejianc.foundation.ai.vo.material.AiMaterialParam;
import com.ejianc.foundation.ai.vo.material.AiMaterialTrainVO;
import com.ejianc.foundation.ai.vo.material.AiMaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(name= "ejc-ai-web", url="${common.env.feign-client-url}", path="ejc-ai-web", fallback = MaterialMaterialAiHystrix.class)
public interface IMaterialAiApi {

    /**
     * 批量拆分物料属性
     * 返回拆分后的格式化数据
     * */
    @RequestMapping(value = "/ai/material/recognize", method = RequestMethod.POST)
    CommonResponse<List<AiMaterialVO>> aiMaterialRecognize(@RequestBody List<AiMaterialParam> aiMaterialParams);

    @RequestMapping(value = "/ai/material/train", method = RequestMethod.POST)
    CommonResponse<String> putMaterial2AiTrain(@RequestBody List<AiMaterialTrainVO> aiMaterialTrainVos);

}
