package com.ejianc.foundation.ai.api;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.teautil.Common;
import com.ejianc.foundation.ai.api.param.*;
import com.ejianc.foundation.ai.api.result.ChunkResult;
import com.ejianc.foundation.ai.api.result.KnowledgeCategoryResult;
import com.ejianc.foundation.ai.api.result.KnowledgeItemResult;
import com.ejianc.foundation.ai.hystrix.KnowledgeHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name= "ejc-ai-web", url="${common.env.feign-client-url}", path="ejc-ai-web", fallback = KnowledgeHystrix.class)
public interface IKnowledgeApi {

    /**
     * 新增知识库
     * @param knowledgeBaseParam
     * @return
     */
    @RequestMapping(value = "/ai/knowledge/createKnowledgeBase", method = RequestMethod.POST)
    public CommonResponse<String> createKnowledgeBase(@RequestBody KnowledgeBaseParam knowledgeBaseParam);
    /**
     * 新增知识
     *
     * @return
     */
    @RequestMapping(value = "/ai/knowledge/createKnowledgeItem", method = RequestMethod.POST)
    public CommonResponse<KnowledgeItemResult> createKnowledgeItem(@RequestBody KnowledgeItemParam knowledgeItemParam);

    /**
     * 新增切片
     *
     * @return
     */
    @RequestMapping(value = "/ai/knowledge/createChunk", method = RequestMethod.POST)
    public CommonResponse<ChunkResult> createChunk(@RequestBody ChunkParam chunkParam);
    /**
     * 修改切片
     *
     * @return
     */
    @RequestMapping(value = "/ai/knowledge/updateChunk", method = RequestMethod.POST)
    public CommonResponse<ChunkResult> updateChunk(@RequestBody UpdateChunkParam updateChunkParam);
    /**
     * 删除切片
     *
     * @return
     */
    @RequestMapping(value = "/ai/knowledge/deleteChunk", method = RequestMethod.POST)
    public CommonResponse<String> deleteChunk(@RequestBody Long chunkId);
}
