package com.ejianc.foundation.ai.vo.receipt;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Optional;

public class AiReceiptVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id; // 主键ID

    private Long categoryId; // 物料分类

    private String categoryName; // 物料分类名称

    private String code; // 物料编码

    private String name;// 物料名称

    private String spec; // 规格

    private String unitName;// 计量单位名称

    private BigDecimal num;

    private BigDecimal price;

    private BigDecimal money;

    private Long tenantId; // 租户ID


    private String key; // 物料名称 + 规格 + 计量单位

    public String getKey() {
        return Optional.ofNullable(this.name).orElse("") + Optional.ofNullable(this.spec).orElse("") + Optional.ofNullable(this.unitName).orElse("");
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
}
