package com.ejianc.business.cefoc.asip.api;

import com.ejianc.business.cefoc.asip.hystrix.CefocApplyHystrix;
import com.ejianc.business.cefoc.asip.vo.ApplyInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


@FeignClient(name = "ejc-asip-web", url = "${common.env.feign-client-url}", path = "ejc-asip-web", fallback = CefocApplyHystrix.class)
public interface ICefocApplyApi {
    /**
     * 根据客户端信息获取应用信息
     *
     * @return
     */
    @GetMapping("api/app/getAppInfo")
    @ResponseBody
    CommonResponse<ApplyInfoVO> getAppLyInfo(@RequestParam String clientId, @RequestParam String clientSecret);
}
