package com.ejianc.business.cefoc.asip.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 应用鉴权
 * 
 * @author generator
 * 
 */
 @TableName("ejc_asip_app_auth")
public class AppAuthEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    public static final String NO_AUTH = "none";
    public static final String TOKEN_AUTH = "token";
    public static final String SIMPLE_AUTH = "simple";

    @TableField(value="app_id")
    private Long appId; // 应用id
    @TableField(value="type")
    private String type; // 类别，http，webService

    @TableField(value="auth_type")
    private String authType; // 鉴权类别，none：无鉴权，token：token鉴权，simple：简单鉴权
    @TableField(value="mode")
    private String mode; // 请求类型
    @TableField(value="address")
    private String address; // 地址

    @TableField(value="request_body_format")
    private String requestBodyFormat; // 请求体格式

    /*************WebService信息*****************/
    @TableField(value="web_wsdl_address")
    private String webWsdlAddress; // WSDL地址
    @TableField(value="web_service")
    private String webService; // service
    @TableField(value="web_port")
    private String webPort; // port
    @TableField(value="web_operation")
    private String webOperation; // operation
    @TableField(value="web_address")
    private String webAddress; // address

    @TableField(exist=false)
    @SubEntity(serviceName="appAuthReqParamService", pidName="authId")
    private List<AppAuthReqParamEntity> appAuthReqParamList = new ArrayList<>(); //
    @TableField(exist=false)
    @SubEntity(serviceName="appReqService", pidName="reqId")
    private List<AppReqEntity> appReqList = new ArrayList<>(); //

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAuthType() {
        return authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRequestBodyFormat() {
        return requestBodyFormat;
    }

    public void setRequestBodyFormat(String requestBodyFormat) {
        this.requestBodyFormat = requestBodyFormat;
    }

    public String getWebWsdlAddress() {
        return webWsdlAddress;
    }

    public void setWebWsdlAddress(String webWsdlAddress) {
        this.webWsdlAddress = webWsdlAddress;
    }

    public String getWebService() {
        return webService;
    }

    public void setWebService(String webService) {
        this.webService = webService;
    }

    public String getWebPort() {
        return webPort;
    }

    public void setWebPort(String webPort) {
        this.webPort = webPort;
    }

    public String getWebOperation() {
        return webOperation;
    }

    public void setWebOperation(String webOperation) {
        this.webOperation = webOperation;
    }

    public String getWebAddress() {
        return webAddress;
    }

    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public List<AppAuthReqParamEntity> getAppAuthReqParamList() {
        return appAuthReqParamList;
    }

    public void setAppAuthReqParamList(List<AppAuthReqParamEntity> appAuthReqParamList) {
        this.appAuthReqParamList = appAuthReqParamList;
    }

    public List<AppReqEntity> getAppReqList() {
        return appReqList;
    }

    public void setAppReqList(List<AppReqEntity> appReqList) {
        this.appReqList = appReqList;
    }
}
