package com.ejianc.business.cefoc.asip.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 应用资源-数据结构
 * 
 * @author generator
 * 
 */
 @TableName("ejc_asip_app_data_structure")
public class AppResourceDataStructureEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="app_id")
    private Long appId; // 应用id
    @TableField(value="data_structure_name")
    private String dataStructureName; // 数据结构名称
    @TableField(value="data_structure_identification")
    private String dataStructureIdentification; //数据结构标识
    @TableField(value="data_structure_describe")
    private String dataStructureDescribe; // 数据结构描述
    @TableField(exist=false)
    @SubEntity(serviceName="appResourceDataStructureParamService", pidName="dataStructureId")
    private List<AppResourceDataStructureParamEntity> paramList = new ArrayList<>(); //


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getDataStructureName() {
        return dataStructureName;
    }

    public void setDataStructureName(String dataStructureName) {
        this.dataStructureName = dataStructureName;
    }

    public String getDataStructureIdentification() {
        return dataStructureIdentification;
    }

    public void setDataStructureIdentification(String dataStructureIdentification) {
        this.dataStructureIdentification = dataStructureIdentification;
    }

    public String getDataStructureDescribe() {
        return dataStructureDescribe;
    }

    public void setDataStructureDescribe(String dataStructureDescribe) {
        this.dataStructureDescribe = dataStructureDescribe;
    }

    public List<AppResourceDataStructureParamEntity> getParamList() {
        return paramList;
    }

    public void setParamList(List<AppResourceDataStructureParamEntity> paramList) {
        this.paramList = paramList;
    }
}
