package com.ejianc.business.cefoc.asip.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cefoc.asip.bean.*;
import com.ejianc.business.cefoc.asip.service.*;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.AppVO;
import com.ejianc.business.cefoc.asip.vo.PublishDataVO;
import com.ejianc.business.cefoc.asip.vo.PublishVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 应用
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("app")
public class AppController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    private static final String BILL_CODE = "CEDOC_ASIP_APP";//此处需要根据实际修改

    @Autowired
    private IAppService service;
    @Autowired
    private IAppUserRelationService appUserRelationService;

    @Autowired
    private IAppAuthConfigService appAuthConfigService;
    @Autowired
    private IAppAuthReqParamService appAuthReqParamService;
    @Autowired
    private IAppAuthService appAuthService;
    @Autowired
    private IAppInterfaceService appInterfaceService;
    @Autowired
    private IAppReqService appReqService;
    @Autowired
    private IAppResourceConnectService appResourceConnectService;
    @Autowired
    private IAppResourceConstantService appResourceConstantService;
    @Autowired
    private IAppResourceDataStructureParamService appResourceDataStructureParamService;
    @Autowired
    private IAppResourceDataStructureService appResourceDataStructureService;
    @Autowired
    private IAppResourceLogicService appResourceLogicService;
    @Autowired
    private IAppRespService appRespService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveBaseData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppVO> saveBaseData(@RequestBody AppVO saveOrUpdateVO) {
        AppEntity entity = BeanMapper.map(saveOrUpdateVO, AppEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            Long id = IdWorker.getId();
            entity.setId(id);
            if(StringUtils.isBlank(entity.getAppCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setAppCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }else{
                QueryWrapper<AppEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("app_code", entity.getAppCode());
                wrapper.ne("id", entity.getId());
                List<AppEntity> list = service.list(wrapper);
                if(list!=null && list.size()>0){
                    throw new BusinessException("应用标识重复，请重新输入应用标识");
                }
            }
            //生成用户关系表数据---管理员
            AppUserRelationEntity userRelationEntity = new AppUserRelationEntity();
            userRelationEntity.setAppId(id);
            userRelationEntity.setUserId(InvocationInfoProxy.getUserid());
            userRelationEntity.setType("1");
            appUserRelationService.saveOrUpdate(userRelationEntity, false);
        }else{
            entity = service.selectById(entity.getId());
            if(StringUtils.isNotBlank(entity.getAppIconSrc())){
                if(StringUtils.isNotBlank(saveOrUpdateVO.getAppIconSrc())){
                    if(!entity.getAppIconSrc().equals(saveOrUpdateVO.getAppIconSrc())){
                        //删除原先的应用
                        if(StringUtils.isNotBlank(entity.getAppIconSrc())&&entity.getAppIconSrc().contains("=")){
                            String id = entity.getAppIconSrc().split("=")[1];
                            if(StringUtils.isNotBlank(id)){
                                attachmentApi.delete(id);
                            }
                        }
                        //绑定新的应用图标
                        if(StringUtils.isNotBlank(saveOrUpdateVO.getAppIconSrc())&&saveOrUpdateVO.getAppIconSrc().contains("=")){
                            String id = saveOrUpdateVO.getAppIconSrc().split("=")[1];
                            if(StringUtils.isNotBlank(id)){
                                List<Long> attachIds = new ArrayList<>();
                                attachIds.add(Long.parseLong(id));
                                attachmentApi.updateAttachRef(entity.getId(), attachIds);
                            }
                        }
                    }

                }else{
                    //删除原先的应用
                    if(StringUtils.isNotBlank(entity.getAppIconSrc())&&entity.getAppIconSrc().contains("=")){
                        String id = entity.getAppIconSrc().split("=")[1];
                        if(StringUtils.isNotBlank(id)){
                            attachmentApi.delete(id);
                        }
                    }
                }
            }else{
                if(StringUtils.isNotBlank(saveOrUpdateVO.getAppIconSrc())){
                    //绑定新的应用图标
                    if(StringUtils.isNotBlank(saveOrUpdateVO.getAppIconSrc())&&saveOrUpdateVO.getAppIconSrc().contains("=")){
                        String id = saveOrUpdateVO.getAppIconSrc().split("=")[1];
                        if(StringUtils.isNotBlank(id)){
                            List<Long> attachIds = new ArrayList<>();
                            attachIds.add(Long.parseLong(id));
                            attachmentApi.updateAttachRef(entity.getId(), attachIds);
                        }
                    }
                }
            }
            entity.setAppCode(saveOrUpdateVO.getAppCode());
            entity.setAppName(saveOrUpdateVO.getAppName());
            entity.setAppIconSrc(saveOrUpdateVO.getAppIconSrc());
            entity.setRemark(saveOrUpdateVO.getRemark());

        }
        service.saveOrUpdate(entity, false);
        AppVO vo = BeanMapper.map(entity, AppVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveConfig", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppVO> saveConfig(@RequestBody AppVO saveOrUpdateVO) {
        AppEntity entity = BeanMapper.map(saveOrUpdateVO, AppEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
        }else{
            entity = service.selectById(entity.getId());
            entity.setDateFormat(saveOrUpdateVO.getDateFormat());
            entity.setStringQuote(saveOrUpdateVO.getStringQuote());
            entity.setReserveNull(saveOrUpdateVO.getReserveNull());
            entity.setCaseRecognition(saveOrUpdateVO.getCaseRecognition());
        }
        service.saveOrUpdate(entity, false);
        AppVO vo = BeanMapper.map(entity, AppVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppVO> queryDetail(Long id) {
        AppEntity entity = service.selectById(id);
        AppVO vo = BeanMapper.map(entity, AppVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/changeAppPublish", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeAppPublish(Long id, Integer publish) {
        AppEntity entity = service.selectById(id);
        entity.setPublish(publish);
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("修改成功！");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("app_name");
        fuzzyFields.add("app_code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //获取当前用户权限的应用

        IPage<AppEntity> page = service.queryPage(param,false);
        IPage<AppVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询市场的列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMarketAppList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AppVO>> queryMarketAppList() {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("publish", new Parameter(QueryParam.EQ, 1));
        List<AppEntity> data = service.queryList(param);
        return CommonResponse.success("查询列表数据成功！", BeanMapper.mapList(data, AppVO.class));
    }

    @RequestMapping(value = "/referMarketAppList", method = RequestMethod.GET)
    @ResponseBody
    public List<AppVO> referMarketAppList() {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("publish", new Parameter(QueryParam.EQ, 1));
        List<AppEntity> data = service.queryList(param);
        List<AppVO> vos = BeanMapper.mapList(data, AppVO.class);
        return vos;
    }
    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCefocAsipAppData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AppVO>> refCefocAsipAppData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                            String condition,
                                                            String searchObject,
                                                            String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        QueryWrapper<AppUserRelationEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("user_id", InvocationInfoProxy.getUserid());
        List<AppUserRelationEntity> userList = appUserRelationService.list(wrapper);
        List<Long> appIds = new ArrayList<>();
        if(userList!=null && userList.size()>0){
            for (AppUserRelationEntity en : userList) {
                appIds.add(en.getAppId());
            }
        }
        param.getParams().put("id", new Parameter(QueryParam.IN, appIds));
        IPage<AppEntity> page = service.queryPage(param,false);
        IPage<AppVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * 发布数据
     *
     * @param
     * @return
     */
    @SuppressWarnings("unchecked")
    @ResponseBody
    @RequestMapping(value = "publish")
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank(targetEnv)) {
                return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
            }

            List<AppEntity> appEntities = (List<AppEntity>) service.listByIds(publishVO.getIdList());

            QueryWrapper<AppAuthEntity> appAuthWrapper = new QueryWrapper<>();
            appAuthWrapper.in("app_id", publishVO.getIdList());
            List<AppAuthEntity> appAuthEntities = appAuthService.list(appAuthWrapper);

            QueryWrapper<AppAuthConfigEntity> appAuthConfigWrapper = new QueryWrapper<>();
            appAuthConfigWrapper.in("app_id", publishVO.getIdList());
            List<AppAuthConfigEntity> appAuthConfigEntities = appAuthConfigService.list(appAuthConfigWrapper);

            List<AppAuthReqParamEntity> appAuthReqParamEntities = null;
            List<AppReqEntity> appReqEntities = null;
            if(appAuthEntities!=null && appAuthEntities.size()>0){
                List<Long> authIds = new ArrayList<>();
                for (AppAuthEntity appAuth : appAuthEntities) {
                    authIds.add(appAuth.getId());
                }
                QueryWrapper<AppAuthReqParamEntity> appAuthReqParamWrapper = new QueryWrapper<>();
                appAuthReqParamWrapper.in("auth_id", authIds);
                appAuthReqParamEntities = appAuthReqParamService.list(appAuthReqParamWrapper);

                QueryWrapper<AppReqEntity> appReqWrapper = new QueryWrapper<>();
                appReqWrapper.in("req_id", authIds);
                appReqEntities = appReqService.list(appReqWrapper);
            }

            QueryWrapper<AppInterfaceEntity> appInterfaceWrapper = new QueryWrapper<>();
            appInterfaceWrapper.in("app_id", publishVO.getIdList());
            List<AppInterfaceEntity> appInterfaceEntities = appInterfaceService.list(appInterfaceWrapper);

            List<AppRespEntity> appRespEntities = null;
            if(appInterfaceEntities!=null && appInterfaceEntities.size()>0){
                List<Long> interfaceIds = new ArrayList<>();
                for (AppInterfaceEntity appInterface : appInterfaceEntities) {
                    interfaceIds.add(appInterface.getId());
                }
                QueryWrapper<AppRespEntity> appRespWrapper = new QueryWrapper<>();
                appRespWrapper.in("req_id", interfaceIds);
                appRespEntities = appRespService.list(appRespWrapper);

                QueryWrapper<AppReqEntity> appReqWrapper = new QueryWrapper<>();
                appReqWrapper.in("req_id", interfaceIds);
                List<AppReqEntity> appReqEntities1 = appReqService.list(appReqWrapper);
                if(appReqEntities!=null && appReqEntities.size()>0 && appReqEntities1!=null && appReqEntities1.size()>0){
                    appReqEntities.addAll(appReqEntities1);
                }
            }

            QueryWrapper<AppResourceConnectEntity> appResourceConnectWrapper = new QueryWrapper<>();
            appResourceConnectWrapper.in("app_id", publishVO.getIdList());
            List<AppResourceConnectEntity> appResourceConnectEntities = appResourceConnectService.list(appResourceConnectWrapper);

            QueryWrapper<AppResourceConstantEntity> appResourceConstantWrapper = new QueryWrapper<>();
            appResourceConstantWrapper.in("app_id", publishVO.getIdList());
            List<AppResourceConstantEntity> appResourceConstantEntities = appResourceConstantService.list(appResourceConstantWrapper);

            QueryWrapper<AppResourceDataStructureEntity> appResourceDataStructureWrapper = new QueryWrapper<>();
            appResourceDataStructureWrapper.in("app_id", publishVO.getIdList());
            List<AppResourceDataStructureEntity> appResourceDataStructureEntities = appResourceDataStructureService.list(appResourceDataStructureWrapper);


            List<AppResourceDataStructureParamEntity> appResourceDataStructureParamEntities = null;
            if(appResourceDataStructureEntities!=null && appResourceDataStructureEntities.size()>0){
                List<Long> interfaceIds = new ArrayList<>();
                for (AppResourceDataStructureEntity appResourceDataStructure : appResourceDataStructureEntities) {
                    interfaceIds.add(appResourceDataStructure.getId());
                }
                QueryWrapper<AppResourceDataStructureParamEntity> appResourceDataStructureParamWrapper = new QueryWrapper<>();
                appResourceDataStructureParamWrapper.in("data_structure_id", publishVO.getIdList());
                appResourceDataStructureParamEntities = appResourceDataStructureParamService.list(appResourceDataStructureParamWrapper);
            }

            QueryWrapper<AppResourceLogicEntity> apResourceLogicWrapper = new QueryWrapper<>();
            apResourceLogicWrapper.in("app_id", publishVO.getIdList());
            List<AppResourceLogicEntity> appResourceLogicEntities = appResourceLogicService.list(apResourceLogicWrapper);

            PublishDataVO publishDataVO = new PublishDataVO();
            if(appEntities!=null && appEntities.size()>0){
                appEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appAuthEntities!=null && appAuthEntities.size()>0){
                appAuthEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appAuthConfigEntities!=null && appAuthConfigEntities.size()>0){
                appAuthConfigEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appAuthReqParamEntities!=null && appAuthReqParamEntities.size()>0){
                appAuthReqParamEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appInterfaceEntities!=null && appInterfaceEntities.size()>0){
                appInterfaceEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appReqEntities!=null && appReqEntities.size()>0){
                appReqEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appRespEntities!=null && appRespEntities.size()>0){
                appRespEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appResourceConnectEntities!=null && appResourceConnectEntities.size()>0){
                appResourceConnectEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appResourceConstantEntities!=null && appResourceConstantEntities.size()>0){
                appResourceConstantEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appResourceDataStructureEntities!=null && appResourceDataStructureEntities.size()>0){
                appResourceDataStructureEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appResourceDataStructureParamEntities!=null && appResourceDataStructureParamEntities.size()>0){
                appResourceDataStructureParamEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            if(appResourceLogicEntities!=null && appResourceLogicEntities.size()>0){
                appResourceLogicEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            publishDataVO.setAppEntities(appEntities);
            publishDataVO.setAppAuthEntities(appAuthEntities);
            publishDataVO.setAppAuthConfigEntities(appAuthConfigEntities);
            publishDataVO.setAppAuthReqParamEntities(appAuthReqParamEntities);
            publishDataVO.setAppInterfaceEntities(appInterfaceEntities);
            publishDataVO.setAppReqEntities(appReqEntities);
            publishDataVO.setAppRespEntities(appRespEntities);
            publishDataVO.setAppResourceConnectEntities(appResourceConnectEntities);
            publishDataVO.setAppResourceConstantEntities(appResourceConstantEntities);
            publishDataVO.setAppResourceDataStructureEntities(appResourceDataStructureEntities);
            publishDataVO.setAppResourceDataStructureParamEntities(appResourceDataStructureParamEntities);
            publishDataVO.setAppResourceLogicEntities(appResourceLogicEntities);
            publishDataVO.setIds(publishVO.getIdList());
            publishDataVO.setType("app");

            String url = publishVO.getTarget() + "/cefoc-asip-web/dataTransfer/transferBySql";
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            String paramterStr = gson.toJson(publishDataVO);

            logger.info("发布数据的url：---------------"+url);
            try {
                String result = ReferHttpClientUtils.postByJson(url, paramterStr);
                logger.info("发布数据返回的结果：---------------"+result);
                return gson.fromJson(result, CommonResponse.class);
            } catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error("发布数据失败");
            }
        } catch (Exception e) {
            return CommonResponse.error("发布数据失败:" + e.getMessage());
        }
    }

}
