package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppResourceConnectEntity;
import com.ejianc.business.cefoc.asip.service.IAppResourceConnectService;
import com.ejianc.business.cefoc.asip.vo.AppResourceConnectVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 应用资源-连接
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("appResourceConnect")
public class AppResourceConnectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAppResourceConnectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppResourceConnectVO> saveOrUpdate(@RequestBody AppResourceConnectVO saveOrUpdateVO) {
    	AppResourceConnectEntity entity = BeanMapper.map(saveOrUpdateVO, AppResourceConnectEntity.class);
        if(entity.getId()!=null){
            entity = service.selectById(entity.getId());
            entity.setConnectName(saveOrUpdateVO.getConnectName());
            entity.setConnectIdentification(saveOrUpdateVO.getConnectIdentification());
            entity.setConnectDescribe(saveOrUpdateVO.getConnectDescribe());
            entity.setConnectType(saveOrUpdateVO.getConnectType());
            entity.setDatabaseType(saveOrUpdateVO.getDatabaseType());
            entity.setDatabaseHost(saveOrUpdateVO.getDatabaseHost());
            entity.setDatabasePort(saveOrUpdateVO.getDatabasePort());
            entity.setDatabaseUser(saveOrUpdateVO.getDatabaseUser());
            entity.setDatabasePassword(saveOrUpdateVO.getDatabasePassword());
            entity.setConnectConfig(saveOrUpdateVO.getConnectConfig());
            entity.setDatabaseName(saveOrUpdateVO.getDatabaseName());
        }
    	service.saveOrUpdate(entity, false);
    	AppResourceConnectVO vo = BeanMapper.map(entity, AppResourceConnectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @RequestMapping(value = "/testConnect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> testConnect(@RequestBody AppResourceConnectVO vo) {
        return service.testConnect(vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppResourceConnectVO> queryDetail(Long id) {
    	AppResourceConnectEntity entity = service.selectById(id);
    	AppResourceConnectVO vo = BeanMapper.map(entity, AppResourceConnectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppResourceConnectVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("connectName");
        fuzzyFields.add("connectIdentification");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AppResourceConnectEntity> page = service.queryPage(param,false);
        IPage<AppResourceConnectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppResourceConnectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAppResourceConnectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AppResourceConnectVO>> refAppResourceConnectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("appId")!=null){
                param.getParams().put("appId", new Parameter(QueryParam.EQ, _con.get("appId")));
            }
        }
        IPage<AppResourceConnectEntity> page = service.queryPage(param,false);
        IPage<AppResourceConnectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppResourceConnectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
