package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.*;
import com.ejianc.business.cefoc.asip.service.IApplyService;
import com.ejianc.business.cefoc.asip.service.IWaitApplyService;
import com.ejianc.business.cefoc.asip.vo.ApplyInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.ApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Base64Util;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 申请表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("apply")
public class ApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IApplyService service;
    @Autowired
    private IWaitApplyService waitApplyService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "CEDOC_ASIP_APPLY";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO saveOrUpdateVO) {
    	ApplyEntity entity = BeanMapper.map(saveOrUpdateVO, ApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillState(0);
        }else{
            ApplyEntity old = service.selectById(entity.getId());
            entity.setTenantId(old.getTenantId());
            entity.setCreateTime(old.getCreateTime());
            entity.setCreateTime(old.getCreateTime());
            entity.setVersion(old.getVersion());
            entity.setSyncEsFlag(old.getSyncEsFlag());
        }
    	service.saveOrUpdate(entity, false);
    	ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @RequestMapping(value = "/generateApplyForm", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyVO> generateApplyForm(@RequestBody ApplyVO saveOrUpdateVO) {
    	ApplyEntity entity = BeanMapper.map(saveOrUpdateVO, ApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillState(0);
            entity.setState(1);
            String clientId = IdWorker.getId()+"";
            String clientSecret = Base64Util.encode(clientId.getBytes());
            entity.setClientId(clientId);
            entity.setClientSecret(clientSecret);
            for (ApplyInterfaceEntity en : entity.getApplyInterfaceList()) {
                en.setState(1);
                en.setClientId(clientId);
                en.setClientSecret(clientSecret);
            }
        }else{
            ApplyEntity old = service.selectById(entity.getId());
            entity.setTenantId(old.getTenantId());
            entity.setCreateTime(old.getCreateTime());
            entity.setCreateTime(old.getCreateTime());
            entity.setVersion(old.getVersion());
            entity.setSyncEsFlag(old.getSyncEsFlag());
        }
    	service.saveOrUpdate(entity, false);
    	ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
        List<Long> waitIds = new ArrayList<>();
        for (ApplyInterfaceVO applyInterfaceVO : saveOrUpdateVO.getApplyInterfaceList()) {
            waitIds.add(applyInterfaceVO.getWaitId());
        }
        if(waitIds!=null && waitIds.size()>0){
            waitApplyService.removeByIds(waitIds);
        }
    	return CommonResponse.success("生成申请单成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(Long id) {
    	ApplyEntity entity = service.selectById(id);
    	ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @RequestMapping(value = "/updateState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> updateState(Long id, Integer state) {
    	ApplyEntity entity = service.selectById(id);
        entity.setState(state);
        for (ApplyInterfaceEntity en : entity.getApplyInterfaceList()) {
            en.setState(state);
        }
        service.saveOrUpdate(entity, false);
    	ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        service.removeByIds(vos.stream().map(ApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ApplyEntity> page = service.queryPage(param,false);
        IPage<ApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCefocAsipApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> refCefocAsipApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                String condition,
                                                                String searchObject,
                                                                String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ApplyEntity> page = service.queryPage(param,false);
        IPage<ApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
