package com.ejianc.business.cefoc.asip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.service.IJobInfoService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.job.admin.api.IJobAdminApi;
import com.xxl.job.admin.core.model.XxlJobGroup;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;

/**
 * 定时任务信息配置表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("jobGroup")
public class JobGroupController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IJobInfoService service;

    @Autowired
    private IJobAdminApi jobAdminApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<XxlJobGroup> saveOrUpdate(@RequestBody XxlJobGroup saveOrUpdateVO) {
        saveOrUpdateVO.setAddressType(0);
        if(saveOrUpdateVO.getId() == 0){
            CommonResponse<XxlJobGroup> response = jobAdminApi.addGroup(saveOrUpdateVO);
            if(!response.isSuccess()){
                return CommonResponse.error(response.getMsg());
            }
        }else {
            CommonResponse<String> response = jobAdminApi.updateGroup(saveOrUpdateVO);
            if(!response.isSuccess()){
                return CommonResponse.error(response.getMsg());
            }
        }
    	return CommonResponse.success("保存或修改单据成功！",saveOrUpdateVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<XxlJobGroup> vos) {
        StringBuilder sb = new StringBuilder("删除执行器失败！");
        int successCount = 0;
        for (XxlJobGroup jobGroup : vos) {
            CommonResponse<String> response = jobAdminApi.removeGroup(jobGroup.getId());
            if(!response.isSuccess()){
               sb.append(response.getMsg());
            }
            successCount++;
        }
        if(successCount == vos.size()){
            return CommonResponse.success("删除成功！");
        }
        return CommonResponse.success("部分删除成功！"+ sb);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<XxlJobGroup>> queryList(@RequestBody QueryParam param) {
        CommonResponse<List<XxlJobGroup>> response = jobAdminApi.queryGroupList();
        if(!response.isSuccess()){
            return CommonResponse.error("查询执行器列表失败！"+  response.getMsg());
        }
        List<XxlJobGroup> originRecords = response.getData();
        List<XxlJobGroup> records = new ArrayList<>();
        if(StringUtils.isEmpty(param.getSearchText())){
            records = originRecords;
        }else {
            for (XxlJobGroup jobGroup : originRecords) {
                if(jobGroup.getTitle().contains(param.getSearchText()) ||
                        jobGroup.getAddressList().contains(param.getSearchText()) ||
                        jobGroup.getAppName().contains(param.getSearchText())
                ){
                    records.add(jobGroup);
                }
            }
        }

        IPage<XxlJobGroup> pageData = new Page<>(1, 10, records.size());
  		pageData.setRecords(records);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refJobGroupData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<XxlJobGroup>> refJobGroupData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        CommonResponse<List<XxlJobGroup>> response = jobAdminApi.queryGroupList();
        if(!response.isSuccess()){
            return CommonResponse.error("查询执行器列表失败！"+  response.getMsg());
        }
        List<XxlJobGroup> originRecords = response.getData();
        List<XxlJobGroup> records = new ArrayList<>();
        if(StringUtils.isEmpty(searchText)){
            records = originRecords;
        }else {
            for (XxlJobGroup jobGroup : originRecords) {
                if(jobGroup.getTitle().contains(searchText) ||
                        jobGroup.getAddressList().contains(searchText) ||
                        jobGroup.getAppName().contains(searchText)
                ){
                    records.add(jobGroup);
                }
            }
        }
        IPage<XxlJobGroup> pageData = new Page<>(1, 10, records.size());
        pageData.setRecords(records);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
