package com.ejianc.business.cefoc.asip.controller;

import java.io.Serializable;

import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.JobInfoParamEntity;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.vo.JobInfoParamVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.job.admin.api.IJobAdminApi;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLog;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cefoc.asip.bean.JobInfoEntity;
import com.ejianc.business.cefoc.asip.service.IJobInfoService;
import com.ejianc.business.cefoc.asip.vo.JobInfoVO;

/**
 * 定时任务信息配置表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("jobInfo")
public class JobInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IJobInfoService service;
    @Autowired
    private IJobAdminApi jobAdminApi;
    @Autowired
    private IAppInterfaceService interfaceService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JobInfoVO> saveOrUpdate(@RequestBody JobInfoVO saveOrUpdateVO) {
    	JobInfoEntity entity = BeanMapper.map(saveOrUpdateVO, JobInfoEntity.class);
    	JSONObject executorParam = new JSONObject();
        executorParam.put("appIdForJobAdmin", entity.getAppId());
        executorParam.put("urlIdForJobAdmin", entity.getUrlId());
        executorParam.put("connTimeOut", entity.getConnTimeOut());
        executorParam.put("readTimeOut", entity.getReadTimeOut());
        AppInterfaceEntity appInterfaceEntity = interfaceService.getById(entity.getUrlId());
        executorParam.put("urlForJobAdmin", appInterfaceEntity.getInterfaceAddress());
        if(ListUtil.isNotEmpty(saveOrUpdateVO.getParamEntities())){
            for (JobInfoParamVO paramEntity : saveOrUpdateVO.getParamEntities()) {
                if(!"del".equals(paramEntity.getRowState())){
                    executorParam.put(paramEntity.getParamKey(), paramEntity.getParamValue());
                }
            }
        }
        XxlJobInfo jobInfo;
        if(entity.getId() == null || entity.getId() == 0){
            entity.setCode("JOB-"+UUID.randomUUID().toString().replace("-", "").toLowerCase().substring(0, 10));
            entity.setJobState(false);
            jobInfo = new XxlJobInfo();
            jobInfo.setJobGroup(saveOrUpdateVO.getJobGroup());
            jobInfo.setJobCron(saveOrUpdateVO.getJobCron());
            jobInfo.setJobDesc(saveOrUpdateVO.getName());
            jobInfo.setAddTime(new Date());
            jobInfo.setExecutorHandler("zdsJCJobHandler");//固定
            jobInfo.setGlueRemark("GLUE代码初始化");
            jobInfo.setGlueType("BEAN");
            jobInfo.setGlueUpdatetime(new Date());
            jobInfo.setExecutorParam(executorParam.toJSONString());
            jobInfo.setExecutorFailRetryCount(2);
            jobInfo.setExecutorBlockStrategy("SERIAL_EXECUTION");
            jobInfo.setExecutorRouteStrategy("ROUND");
            jobInfo.setExecutorTimeout(100);
            jobInfo.setAlarmEmail("");
            jobInfo.setAuthor(InvocationInfoProxy.getUsercode());
            CommonResponse<XxlJobInfo> response = jobAdminApi.add(jobInfo);
            if(!response.isSuccess()){
                logger.error("新增定时任务失败！{}",response.getMsg());
              return CommonResponse.error("新增定时任务失败！");
            }
            jobInfo = response.getData();
        }else{
            CommonResponse<XxlJobInfo> response = jobAdminApi.queryOne(entity.getJobId());
            if(!response.isSuccess()){
                logger.error("查询定时任务失败！{}",response.getMsg());
                return CommonResponse.error("修改定时任务失败！");
            }
            jobInfo = response.getData();
            jobInfo.setJobCron(saveOrUpdateVO.getJobCron());
            jobInfo.setJobDesc(saveOrUpdateVO.getName());
            jobInfo.setUpdateTime(new Date());
            jobInfo.setExecutorParam(executorParam.toJSONString());
            CommonResponse<String> resp = jobAdminApi.update(jobInfo);
            if(!resp.isSuccess()){
                logger.error("更新定时任务失败！{}",resp.getMsg());
                return CommonResponse.error("修改定时任务失败！");
            }
        }
        entity.setJobId(jobInfo.getId());
    	service.saveOrUpdate(entity, false);
    	JobInfoVO vo = BeanMapper.map(entity, JobInfoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JobInfoVO> queryDetail(Long id) {
    	JobInfoEntity entity = service.selectById(id);
    	JobInfoVO vo = BeanMapper.map(entity, JobInfoVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<JobInfoVO> vos) {
        QueryParam param = QueryParam.getInstance();
        param.getParams().put("id", new Parameter(QueryParam.IN, vos.stream().map(JobInfoVO::getId).collect(Collectors.toList())));
        List<JobInfoEntity> entityList = service.queryList(param,  false);
        List<Long> jobIds = new ArrayList<>();
        StringBuilder sb = new StringBuilder("删除定时任务失败！");
        for (JobInfoEntity entity : entityList) {
            CommonResponse<String> response = jobAdminApi.remove(entity.getJobId());
            if(!response.isSuccess()){
                logger.error("删除定时任务失败！{}",response.getMsg());
                sb.append(response.getMsg());
                continue;
            }
            jobIds.add(entity.getId());
        }
        if(ListUtil.isEmpty(jobIds)){
            return CommonResponse.error(sb.toString());
        }
        service.removeByIds(jobIds,true);
        if(jobIds.size() == entityList.size()){
            return CommonResponse.success("删除成功！");
        }
        return CommonResponse.success("部分删除成功！"+jobIds.size()+"条数据删除成功！"+(entityList.size()-jobIds.size())+"条数据删除失败！"+ sb);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JobInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<JobInfoEntity> page = service.queryPage(param,false);
        IPage<JobInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), JobInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<JobInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("JobInfo-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refJobInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<JobInfoVO>> refJobInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<JobInfoEntity> page = service.queryPage(param,false);
        IPage<JobInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), JobInfoVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 启动调度任务
     * @param id
     */
    @RequestMapping(value = "/start", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> start(Long id) {
        JobInfoEntity entity = service.selectById(id);
        if(entity == null){
            return CommonResponse.error("启动调度任务失败！任务不存在！");
        }
        CommonResponse<String> response = jobAdminApi.start(entity.getJobId());
        if(!response.isSuccess()){
            logger.error("启动调度任务失败！{}",response.getMsg());
            return response;
        }
        entity.setJobState(true);
        service.saveOrUpdate(entity, false);
        return response;
    }


    /**
     * @Description 停止调度任务
     * @param id
     */
    @RequestMapping(value = "/stop", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> stop(Long id) {
        JobInfoEntity entity = service.selectById(id);
        if(entity == null){
            return CommonResponse.error("停止调度任务失败！任务不存在！");
        }
        CommonResponse<String> response = jobAdminApi.stop(entity.getJobId());
        if(!response.isSuccess()){
            logger.error("停止调度任务失败！{}",response.getMsg());
            return response;
        }
        entity.setJobState(false);
        service.saveOrUpdate(entity, false);
        return response;
    }

    /**
     * @Description 停止调度任务
     * @param id
     */
    @RequestMapping(value = "/triggerJob", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> triggerJob(Long id) {
        JobInfoEntity entity = service.selectById(id);
        if(entity == null){
            return CommonResponse.error("执行调度任务失败！任务不存在！");
        }
        JSONObject executorParam = new JSONObject();
        executorParam.put("appIdForJobAdmin", entity.getAppId());
        executorParam.put("urlIdForJobAdmin", entity.getUrlId());
        executorParam.put("connTimeOut", entity.getConnTimeOut());
        executorParam.put("readTimeOut", entity.getReadTimeOut());
        AppInterfaceEntity appInterfaceEntity = interfaceService.getById(entity.getUrlId());
        executorParam.put("urlForJobAdmin", appInterfaceEntity.getInterfaceAddress());
        if(ListUtil.isNotEmpty(entity.getParamEntities())){
            for (JobInfoParamEntity paramEntity : entity.getParamEntities()) {
                if(!"del".equals(paramEntity.getRowState())){
                    executorParam.put(paramEntity.getParamKey(), paramEntity.getParamValue());
                }
            }
        }
        return jobAdminApi.triggerJob(entity.getJobId(),executorParam.toJSONString());
    }

    /**
     * 分页查询调度任务日志
     */
    @PostMapping("pageLogList")
    @ResponseBody
    public CommonResponse<Page<XxlJobLog>> pageLogList(@RequestBody QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        int jobGroup = param.getParams().get("jobGroup")!=null?Integer.parseInt(param.getParams().get("jobGroup").getValue().toString()):0;
        int jobId = param.getParams().get("jobId")!=null? Integer.parseInt(param.getParams().get("jobId").getValue().toString()):0;
        int logStatus = param.getParams().get("logStatus")!=null? Integer.parseInt(param.getParams().get("logStatus").getValue().toString()):-1;
        String filterTime = param.getParams().get("filterTime")!=null?param.getParams().get("filterTime").getValue().toString():null;
        if(StringUtils.isNotEmpty(filterTime)){
            String[] times = filterTime.split(",");
            filterTime = times[0]+" 00:00:00,"+times[1]+" 23:59:59";
        }
        return jobAdminApi.pageLogList(pageIndex, pageSize, jobGroup, jobId, logStatus, filterTime);
    }

    /**
     * 查询执行日志详情
     *
     * @param executorAddress 执行器地址
     * @param triggerTime     触发时间
     * @param logId           日志ID
     * @return
     */
    @GetMapping("logDetailCat")
    @ResponseBody
    public CommonResponse<String> logDetailCat(@RequestParam String executorAddress,
                                                        @RequestParam long triggerTime,
                                                        @RequestParam int logId) {
        return jobAdminApi.logDetailCat( executorAddress, triggerTime, logId,1);
    }
}
