package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.WaitApplyEntity;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IWaitApplyService;
import com.ejianc.business.cefoc.asip.vo.WaitApplyVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 我的待申请表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("waitApply")
public class WaitApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWaitApplyService service;
    @Autowired
    private IAppInterfaceService appInterfaceService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WaitApplyVO> saveOrUpdate(@RequestBody WaitApplyVO saveOrUpdateVO) {
    	WaitApplyEntity entity = BeanMapper.map(saveOrUpdateVO, WaitApplyEntity.class);
        if(entity.getId()!=null){
            entity = service.selectById(entity.getId());
            entity.setInterfaceId(saveOrUpdateVO.getInterfaceId());
            entity.setUserId(saveOrUpdateVO.getUserId());
            entity.setPublish(saveOrUpdateVO.getPublish());
        }
    	service.saveOrUpdate(entity, false);
    	WaitApplyVO vo = BeanMapper.map(entity, WaitApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WaitApplyVO> queryDetail(Long id) {
    	WaitApplyEntity entity = service.selectById(id);
    	WaitApplyVO vo = BeanMapper.map(entity, WaitApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @RequestMapping(value = "/countData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> countData(Long userId) {
        QueryWrapper<WaitApplyEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("user_id", userId);
        Integer count = service.count(wrapper);
        return CommonResponse.success("查询数据成功！",count);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WaitApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<WaitApplyEntity> page = service.queryPage(param,false);
        IPage<WaitApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WaitApplyVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCefocAsipWaitApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WaitApplyVO>> refCefocAsipWaitApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WaitApplyEntity> page = service.queryPage(param,false);
        IPage<WaitApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WaitApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
