package com.ejianc.business.cefoc.asip.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.ApplyEntity;
import com.ejianc.business.cefoc.asip.bean.ApplyInterfaceEntity;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IApplyInterfaceService;
import com.ejianc.business.cefoc.asip.service.IApplyService;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.AppUserRelationVO;
import com.ejianc.business.cefoc.asip.vo.ApplyInfoVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

@Controller
@RequestMapping("api/app")
public class CefocApplyApi implements Serializable {
    private static final long serialVersionUID = -7187097338964236420L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IApplyService applyService;
    @Autowired
    private IApplyInterfaceService applyInterfaceService;
    @Autowired
    private IAppInterfaceService interfaceService;
    /**
     * 根据客户端信息获取应用信息
     *
     * @return
     */
    @GetMapping("getAppInfo")
    @ResponseBody
    public CommonResponse<ApplyInfoVO> getAppLyInfo(@RequestParam String clientId, @RequestParam String clientSecret){
        List<ApplyEntity> applyEntityList = applyService.list(new QueryWrapper<ApplyEntity>()
                .eq("state", 1)
                .eq("client_id", clientId)
                .eq("client_secret", clientSecret)
                .eq("dr", 0));
        if(ListUtil.isEmpty(applyEntityList)){
            logger.error("获取应用信息失败！clientId = {} clientSecret={} 申请单不存在！",clientId,clientSecret);
            return CommonResponse.error("clientId获取鉴权信息失败！");
        }
        ApplyEntity applyEntity = applyEntityList.get(0);
        List<ApplyInterfaceEntity> applyInterfaceEntities = applyInterfaceService.list(new QueryWrapper<ApplyInterfaceEntity>()
                .eq("apply_id", applyEntity.getId())
                .eq("state", 1)
                .eq("dr", 0));
        if(ListUtil.isEmpty(applyInterfaceEntities)){
            logger.error("获取应用信息失败！clientId = {} clientSecret={} 申请单没有任何接口！",clientId,clientSecret);
            return CommonResponse.error("clientId获取鉴权信息失败！");
        }
        List<AppInterfaceEntity> interfaceEntities = interfaceService.list(new QueryWrapper<AppInterfaceEntity>()
                .in("id", applyInterfaceEntities.stream().map(ApplyInterfaceEntity::getInterfaceId).collect(Collectors.toList()))
                .eq("dr", 0));
        ApplyInfoVO applyInfoVO = new ApplyInfoVO();
        List<AppInterfaceVO> interfaceVOS = BeanMapper.mapList(interfaceEntities, AppInterfaceVO.class);
        applyInfoVO.setInterfaceVOS(interfaceVOS);
        AppUserRelationVO userRelationVO = new AppUserRelationVO();
        userRelationVO.setUserId(applyEntity.getUserId());
        applyInfoVO.setUserRelationVO(userRelationVO);
        return CommonResponse.success("获取鉴权接口信息成功！",applyInfoVO);
    }
}
