package com.ejianc.business.cefoc.asip.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cefoc.asip.bean.*;
import com.ejianc.business.cefoc.asip.service.*;
import com.ejianc.business.cefoc.asip.vo.AppAuthReqParamVO;
import com.ejianc.business.cefoc.asip.vo.AppAuthVO;
import com.ejianc.business.cefoc.asip.vo.AppReqVO;
import com.ejianc.business.cefoc.asip.vo.AppResourceDataStructureParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cefoc.asip.mapper.AppAuthMapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 应用鉴权
 * 
 * @author generator
 * 
 */
@Service("appAuthService")
public class AppAuthServiceImpl extends BaseServiceImpl<AppAuthMapper, AppAuthEntity> implements IAppAuthService {


    @Autowired
    private IAppAuthReqParamService appAuthReqParamService;

    @Autowired
    private IAppReqService appReqService;

    @Autowired
    private IInterfaceHandlerService interfaceHandlerService;
    @Override
    public AppAuthVO queryDetailByAppId(Long appId, String type) {
        AppAuthVO vo = null;
        QueryWrapper<AppAuthEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("app_id", appId);
        wrapper.eq("type", type);
        AppAuthEntity entity = this.getOne(wrapper);
        if(entity!=null){
            vo = BeanMapper.map(entity, AppAuthVO.class);
            QueryWrapper<AppAuthReqParamEntity> configWrapper = new QueryWrapper<>();
            configWrapper.eq("auth_id", entity.getId());
            List<AppAuthReqParamEntity> configList = appAuthReqParamService.list(configWrapper);

            List<AppAuthReqParamVO> headerSetReqList = new ArrayList<>();
            List<AppAuthReqParamVO> bodySetReqList = new ArrayList<>();
            List<AppAuthReqParamVO> urlParamSetReqList = new ArrayList<>();
            if(configList!=null && configList.size()>0){
                for(AppAuthReqParamEntity item : configList){
                    if("header".equals(item.getType())){
                        headerSetReqList.add(BeanMapper.map(item, AppAuthReqParamVO.class));
                    }else if("body".equals(item.getType())){
                        bodySetReqList.add(BeanMapper.map(item, AppAuthReqParamVO.class));
                    }else if("urlParam".equals(item.getType())){
                        urlParamSetReqList.add(BeanMapper.map(item, AppAuthReqParamVO.class));
                    }
                }
            }
            vo.setHeaderSetReqList(headerSetReqList);
            vo.setBodySetReqList(bodySetReqList);
            vo.setUrlParamSetReqList(urlParamSetReqList);

            List<AppReqVO> headerReqList = new ArrayList<>();
            List<AppReqVO> bodyReqList = new ArrayList<>();
            List<AppReqVO> urlParamReqList = new ArrayList<>();
            QueryWrapper<AppReqEntity> reqWrapper = new QueryWrapper<>();
            reqWrapper.eq("req_id", entity.getId());
            List<AppReqEntity> reqList = appReqService.list(reqWrapper);
            if(reqList!=null && reqList.size()>0){
                for(AppReqEntity item : reqList){
                    if("header".equals(item.getType())){
                        headerReqList.add(BeanMapper.map(item, AppReqVO.class));
                    }else if("body".equals(item.getType())){
                        bodyReqList.add(BeanMapper.map(item, AppReqVO.class));
                    }else if("urlParam".equals(item.getType())){
                        urlParamReqList.add(BeanMapper.map(item, AppReqVO.class));
                    }
                }
            }
            vo.setHeaderReqList(headerReqList);

            List<AppReqVO> detailVOS = createTreeData(bodyReqList);
            vo.setBodyReqList(detailVOS);
            vo.setUrlParamReqList(urlParamReqList);
        }

        return vo;
    }

    @Override
    public AppAuthVO saveData(AppAuthVO saveOrUpdateVO) {
        AppAuthEntity entity = BeanMapper.map(saveOrUpdateVO, AppAuthEntity.class);

        if(saveOrUpdateVO.getId()!=null){
            AppAuthEntity old = this.selectById(saveOrUpdateVO.getId());
            entity.setCreateTime(old.getCreateTime());
            entity.setCreateUserCode(old.getCreateUserCode());
            entity.setTenantId(old.getTenantId());
            entity.setVersion(old.getVersion());
            if(!entity.getAuthType().equals(old.getAuthType())){
                //不一致，清除原先子表数据数据
                QueryWrapper<AppAuthReqParamEntity> configWrapper = new QueryWrapper<>();
                configWrapper.eq("auth_id", entity.getId());
                appAuthReqParamService.remove(configWrapper);

                QueryWrapper<AppReqEntity> reqWrapper = new QueryWrapper<>();
                reqWrapper.eq("req_id", entity.getId());
                appReqService.remove(reqWrapper);
            }
        }
        if("none".equals(entity.getAuthType())){
            //清理数据
            entity.setAddress(null);
            entity.setMode(null);
            entity.setRequestBodyFormat(null);

            entity.setWebWsdlAddress(null);
            entity.setWebService(null);
            entity.setWebPort(null);
            entity.setWebOperation(null);
            entity.setWebAddress(null);

//            QueryWrapper<AppAuthReqParamEntity> configWrapper = new QueryWrapper<>();
//            configWrapper.eq("auth_id", entity.getId());
//            appAuthReqParamService.remove(configWrapper);
//
//            QueryWrapper<AppReqEntity> reqWrapper = new QueryWrapper<>();
//            reqWrapper.eq("req_id", entity.getId());
//            appReqService.remove(reqWrapper);
        }else{
            if("http".equals(entity.getType())){
                entity.setWebWsdlAddress(null);
                entity.setWebService(null);
                entity.setWebPort(null);
                entity.setWebOperation(null);
                entity.setWebAddress(null);
            }else if("webService".equals(entity.getType())){
                entity.setAddress(null);
                entity.setMode(null);
                entity.setRequestBodyFormat(null);
            }
            List<AppAuthReqParamEntity> appAuthReqParamList = new ArrayList<>();
            if(saveOrUpdateVO.getHeaderSetReqList()!=null && saveOrUpdateVO.getHeaderSetReqList().size()>0){
                appAuthReqParamList = BeanMapper.mapList(saveOrUpdateVO.getHeaderSetReqList(), AppAuthReqParamEntity.class);
            }
            if(saveOrUpdateVO.getBodySetReqList()!=null && saveOrUpdateVO.getBodySetReqList().size()>0){
                appAuthReqParamList.addAll(BeanMapper.mapList(saveOrUpdateVO.getBodySetReqList(), AppAuthReqParamEntity.class));
            }
            if(saveOrUpdateVO.getUrlParamSetReqList()!=null && saveOrUpdateVO.getUrlParamSetReqList().size()>0){
                appAuthReqParamList.addAll(BeanMapper.mapList(saveOrUpdateVO.getUrlParamSetReqList(), AppAuthReqParamEntity.class));
            }
            entity.setAppAuthReqParamList(appAuthReqParamList);
            List<AppReqEntity> appReqList = new ArrayList<>(); //
            if(saveOrUpdateVO.getHeaderReqList()!=null && saveOrUpdateVO.getHeaderReqList().size()>0){
                appReqList = BeanMapper.mapList(saveOrUpdateVO.getHeaderReqList(), AppReqEntity.class);
            }
            if(saveOrUpdateVO.getBodyReqList()!=null && saveOrUpdateVO.getBodyReqList().size()>0){
                List<AppReqEntity> paramList = new ArrayList<>();
                paramList = this.dealChildren(saveOrUpdateVO.getBodyReqList(), paramList, null, "body");
                appReqList.addAll(paramList);
            }
            if(saveOrUpdateVO.getUrlParamReqList()!=null && saveOrUpdateVO.getUrlParamReqList().size()>0){
                appReqList.addAll(BeanMapper.mapList(saveOrUpdateVO.getUrlParamReqList(), AppReqEntity.class));
            }
            entity.setAppReqList(appReqList);
        }

        this.saveOrUpdate(entity, false);
        AppAuthVO vo = BeanMapper.map(entity, AppAuthVO.class);
        return vo;
    }

    private List<AppReqEntity> dealChildren(List<AppReqVO> children, List<AppReqEntity> paramList, Long pid, String type) {
        for(AppReqVO param : children){
            param.setPid(pid);
            if("add".equals(param.getRowState())){
                param.setId(IdWorker.getId());
            }
            if(param.getChildren()!=null && param.getChildren().size()>0){
                paramList = this.dealChildren(param.getChildren(), paramList, param.getId(), type);
            }
            AppReqEntity en = BeanMapper.map(param, AppReqEntity.class);
            en.setType(type);
            paramList.add(en);
        }
        return paramList;
    }

    private List<AppReqVO> createTreeData(List<AppReqVO> list) {
        List<AppReqVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        //循环list，放入listMap重
        Map<String, AppReqVO> listMap = new HashMap<>();
        for(AppReqVO item:list) {
            listMap.put(item.getId().toString(), item);
        }
        for(int i =0; i<list.size(); i++) {
            AppReqVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            AppReqVO parent = listMap.get(parentId);
            if(parent != null) {
                List<AppReqVO> child = (List<AppReqVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<AppReqVO> children = new ArrayList<AppReqVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    @Override
    public JSONObject verifyToken(AppAuthVO vo) {
        JSONObject json = new JSONObject();
        if(StringUtils.isBlank(vo.getMode())){
            throw new BusinessException("请求类型未设置");
        }
        if(StringUtils.isBlank(vo.getAddress())){
            throw new BusinessException("请求地址未设置");
        }
        JSONObject param = new JSONObject();
        if("GET".equals(vo.getMode())){
            if(vo.getUrlParamReqList()!=null && vo.getUrlParamReqList().size()>0){
                for (AppReqVO header : vo.getUrlParamReqList()) {
                    param.put(header.getParamName(), header.getParamValue());
                }
            }
        }else{
            if("json".equals(vo.getRequestBodyFormat())){
                if(vo.getBodyReqList()!=null && vo.getBodyReqList().size()>0){
                    param = this.dealJsonParam(param, vo.getBodyReqList());
                }
            }else if("form".equals(vo.getRequestBodyFormat())){
                if(vo.getBodyReqList()!=null && vo.getBodyReqList().size()>0){
                    for (AppReqVO header : vo.getBodyReqList()) {
                        param.put(header.getParamName(), header.getParamValue());
                    }
                }
            }
        }
        CommonResponse<JSONObject> result = interfaceHandlerService.getAuthResult(vo, false);
        json.put("param", param);
        json.put("result", result.getData());
        return json;
    }

    @Override
    public AppAuthVO queryDetail(Long id) {
        AppAuthEntity entity = this.selectById(id);
        AppAuthVO vo = BeanMapper.map(entity, AppAuthVO.class);

        QueryWrapper<AppAuthReqParamEntity> configWrapper = new QueryWrapper<>();
        configWrapper.eq("auth_id", entity.getId());
        List<AppAuthReqParamEntity> configList = appAuthReqParamService.list(configWrapper);

        List<AppAuthReqParamVO> headerSetReqList = new ArrayList<>();
        List<AppAuthReqParamVO> bodySetReqList = new ArrayList<>();
        List<AppAuthReqParamVO> urlParamSetReqList = new ArrayList<>();
        if(configList!=null && configList.size()>0){
            for(AppAuthReqParamEntity item : configList){
                if("header".equals(item.getType())){
                    headerSetReqList.add(BeanMapper.map(item, AppAuthReqParamVO.class));
                }else if("body".equals(item.getType())){
                    bodySetReqList.add(BeanMapper.map(item, AppAuthReqParamVO.class));
                }else if("urlParam".equals(item.getType())){
                    urlParamSetReqList.add(BeanMapper.map(item, AppAuthReqParamVO.class));
                }
            }
        }
        vo.setHeaderSetReqList(headerSetReqList);
        vo.setBodySetReqList(bodySetReqList);
        vo.setUrlParamSetReqList(urlParamSetReqList);

        List<AppReqVO> headerReqList = new ArrayList<>();
        List<AppReqVO> bodyReqList = new ArrayList<>();
        List<AppReqVO> urlParamReqList = new ArrayList<>();
        QueryWrapper<AppReqEntity> reqWrapper = new QueryWrapper<>();
        reqWrapper.eq("req_id", entity.getId());
        List<AppReqEntity> reqList = appReqService.list(reqWrapper);
        if(reqList!=null && reqList.size()>0){
            for(AppReqEntity item : reqList){
                if("header".equals(item.getType())){
                    headerReqList.add(BeanMapper.map(item, AppReqVO.class));
                }else if("body".equals(item.getType())){
                    bodyReqList.add(BeanMapper.map(item, AppReqVO.class));
                }else if("urlParam".equals(item.getType())){
                    urlParamReqList.add(BeanMapper.map(item, AppReqVO.class));
                }
            }
        }
        vo.setHeaderReqList(headerReqList);
        List<AppReqVO> detailVOS = createTreeData(bodyReqList);
        vo.setBodyReqList(detailVOS);
        vo.setUrlParamReqList(urlParamReqList);
        return vo;
    }

    private JSONObject dealJsonParam(JSONObject data, List<AppReqVO> children){
        for (AppReqVO child : children) {
            if(child.getChildren()!=null && child.getChildren().size()>0){
                JSONObject ch = new JSONObject();
                ch = this.dealJsonParam(ch, child.getChildren());
                data.put(child.getParamName(), ch);
            }else{
                data.put(child.getParamName(), child.getParamValue());
            }
        }
        return data;
    }
}
