package com.ejianc.business.cefoc.asip.utils.sql.dataprovider;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.Map;

/**
 * Created by zyong on 2017/1/9.
 */
public abstract class InnerAggregator implements Aggregatable {

    protected Map<String, String> dataSource;
    protected Map<String, String> query;
    
    @Autowired
    protected RedisTemplate<String, Object> redisTemplate;

    public InnerAggregator() {}

    public abstract void loadData(String[][] data, long interval);

    public void setDataSource(Map<String, String> dataSource) {
        this.dataSource = dataSource;
    }

    public void setQuery(Map<String, String> query) {
        this.query = query;
    }

    protected String getCacheKey() {
        return Hashing.md5().newHasher().putString(
                JSONObject.toJSON(dataSource).toString() + JSONObject.toJSON(query).toString(),
                Charsets.UTF_8).hash().toString();
    }

    public boolean checkExist() {
        return redisTemplate.boundValueOps(getCacheKey()).get() != null;
    }

    public void cleanExist() {
    	redisTemplate.delete(getCacheKey());
    }

    public void beforeLoad(String[] header) {}
    public void loadBatch(String[] header, String[][] data) {}
    public void afterLoad(){}
}
