package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppCategoryEntity;
import com.ejianc.business.cefoc.asip.bean.AppResourceDataStructureEntity;
import com.ejianc.business.cefoc.asip.bean.AppResourceDataStructureParamEntity;
import com.ejianc.business.cefoc.asip.service.IAppResourceDataStructureService;
import com.ejianc.business.cefoc.asip.vo.AppCategoryVO;
import com.ejianc.business.cefoc.asip.vo.AppResourceDataStructureParamVO;
import com.ejianc.business.cefoc.asip.vo.AppResourceDataStructureVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 应用资源-数据结构
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("appResourceDataStructure")
public class AppResourceDataStructureController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAppResourceDataStructureService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppResourceDataStructureVO> saveOrUpdate(@RequestBody AppResourceDataStructureVO saveOrUpdateVO) {
    	AppResourceDataStructureEntity entity = BeanMapper.map(saveOrUpdateVO, AppResourceDataStructureEntity.class);
        if(entity.getId()!=null){
            entity = service.selectById(entity.getId());
            entity.setDataStructureName(saveOrUpdateVO.getDataStructureName());
            entity.setDataStructureIdentification(saveOrUpdateVO.getDataStructureIdentification());
            entity.setDataStructureDescribe(saveOrUpdateVO.getDataStructureDescribe());
            if(saveOrUpdateVO.getParamList()!=null && saveOrUpdateVO.getParamList().size()>0){
                List<AppResourceDataStructureParamEntity> paramList = new ArrayList<>();
                paramList = this.dealChildren(saveOrUpdateVO.getParamList(), paramList, null);
                entity.setParamList(paramList);
            }
        }
    	service.saveOrUpdate(entity, false);
    	AppResourceDataStructureVO vo = BeanMapper.map(entity, AppResourceDataStructureVO.class);
        List<AppResourceDataStructureParamVO> detailVOS = createTreeData(vo.getParamList());
        vo.setParamList(detailVOS);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    private List<AppResourceDataStructureParamEntity> dealChildren(List<AppResourceDataStructureParamVO> children, List<AppResourceDataStructureParamEntity> paramList, Long pid) {
        for(AppResourceDataStructureParamVO param : children){
            param.setPid(pid);
            if("add".equals(param.getRowState())){
                param.setId(IdWorker.getId());
            }
            if(param.getChildren()!=null && param.getChildren().size()>0){
                paramList = this.dealChildren(param.getChildren(), paramList, param.getId());
            }
            AppResourceDataStructureParamEntity en = BeanMapper.map(param, AppResourceDataStructureParamEntity.class);
            paramList.add(en);
        }
        return paramList;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppResourceDataStructureVO> queryDetail(Long id) {
    	AppResourceDataStructureEntity entity = service.selectById(id);
    	AppResourceDataStructureVO vo = BeanMapper.map(entity, AppResourceDataStructureVO.class);

        List<AppResourceDataStructureParamVO> detailVOS = createTreeData(vo.getParamList());
        vo.setParamList(detailVOS);

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    private List<AppResourceDataStructureParamVO> createTreeData(List<AppResourceDataStructureParamVO> list) {
        List<AppResourceDataStructureParamVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        //循环list，放入listMap重
        Map<String, AppResourceDataStructureParamVO> listMap = new HashMap<>();
        for(AppResourceDataStructureParamVO item:list) {
            listMap.put(item.getId().toString(), item);
        }
        for(int i =0; i<list.size(); i++) {
            AppResourceDataStructureParamVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            AppResourceDataStructureParamVO parent = listMap.get(parentId);
            if(parent != null) {
                List<AppResourceDataStructureParamVO> child = (List<AppResourceDataStructureParamVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<AppResourceDataStructureParamVO> children = new ArrayList<AppResourceDataStructureParamVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppResourceDataStructureVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("dataStructureName");
        fuzzyFields.add("dataStructureIdentification");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<AppResourceDataStructureEntity> page = service.queryPage(param,false);
        IPage<AppResourceDataStructureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppResourceDataStructureVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryAllList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<AppResourceDataStructureVO>> queryAllList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<AppResourceDataStructureEntity> data = service.queryList(param,false);
        List<AppResourceDataStructureVO> list = new ArrayList<>();
        if(data!=null && data.size()>0){
            list = BeanMapper.mapList(data, AppResourceDataStructureVO.class);
        }
        return CommonResponse.success("查询列表数据成功！",list);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDataStructureList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AppResourceDataStructureVO>> refDataStructureList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AppResourceDataStructureEntity> page = service.queryPage(param,false);
        IPage<AppResourceDataStructureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppResourceDataStructureVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
