package com.ejianc.business.cefoc.asip.controller;

import com.ejianc.business.cefoc.asip.service.WebServiceClientUtil;
import com.ejianc.business.cefoc.asip.vo.WsdlConfig;
import com.ejianc.business.cefoc.asip.vo.WsdlRequest;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/wsdl")
public class WsdlController {

    /**
     * 调用WSDL服务
     * @param request
     * wsdl地址：http://ws.webxml.com.cn/webservices/qqOnlineWebService.asmx?wsdl
     * 参考请求参数
     * {
     *   "namespace" : "http://WebXml.com.cn/",
     *   "operationName" : "qqCheckOnline",
     *   "params" : {
     *     "qqCode" : "340705421"
     *   },
     *   "wsdlUrl" : "http://ws.webxml.com.cn/webservices/qqOnlineWebService.asmx"
     * }
     * 或者
     * {
     *   "namespace" : "http://WebXml.com.cn/",
     *   "operationName" : "getMobileCodeInfo",
     *   "params" : {
     *     "mobileCode" : "13716203560",
     *     "userID": ""
     *   },
     *   "wsdlUrl" : "http://ws.webxml.com.cn/WebServices/MobileCodeWS.asmx?wsdl"
     * }
     *
     * @return
     */

    @PostMapping("/call")
    @ResponseBody()
    public CommonResponse<String> callWsdl(@RequestBody WsdlRequest request) {
        try {
            WsdlConfig config = new WsdlConfig();
            // 设置配置参数
            config.setWsdlUrl(request.getWsdlUrl());
            config.setNamespace(request.getNamespace());
            config.setServiceName(request.getServiceName());
            config.setPortName(request.getPortName());
            config.setOperationName(request.getOperationName());

            // 调用WSDL服务
            Object result = WebServiceClientUtil.callWebService(config, request.getParams());

            return CommonResponse.success("",result.toString());
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error(e.getMessage());
        }
    }
}
