package com.ejianc.business.cefoc.asip.utils;

import com.ejianc.business.cefoc.asip.utils.sql.config.AggConfig;
import com.ejianc.business.cefoc.asip.utils.sql.config.DimensionConfig;
import com.ejianc.business.cefoc.asip.utils.sql.result.AggregateResult;
import com.ejianc.business.cefoc.asip.utils.sql.result.ColumnIndex;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

import static com.ejianc.business.cefoc.asip.utils.SqlHelper.NULL_STRING;

public class DPCommonUtils {

    public static AggregateResult transform2AggResult(AggConfig config, List<String[]> list) throws Exception {
        // recreate a dimension stream
        Stream<DimensionConfig> dimStream = Stream.concat(config.getColumns().stream(), config.getRows().stream());
        List<ColumnIndex> dimensionList = dimStream.map(ColumnIndex::fromDimensionConfig).collect(Collectors.toList());
        int dimSize = dimensionList.size();
        dimensionList.addAll(config.getValues().stream().map(ColumnIndex::fromValueConfig).collect(Collectors.toList()));
        IntStream.range(0, dimensionList.size()).forEach(j -> dimensionList.get(j).setIndex(j));
        list.forEach(row -> {
            IntStream.range(0, dimSize).forEach(i -> {
                if (row[i] == null) row[i] = NULL_STRING;
            });
        });
        Object[][] result = list.toArray(new Object[][]{});
        return new AggregateResult(dimensionList, result);
    }
}
