/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.cefoc.asip.mapper.ApplyInterfaceMapper;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IAppService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import com.ejianc.job.admin.api.IJobAdminApi;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"statistics"})
public class StatisticsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsController.class);
    @Autowired
    private IAppService appService;
    @Autowired
    private IAppInterfaceService interfaceService;
    @Autowired
    private MongodbCrudTemplate mongodbCrudTemplate;
    @Autowired
    private IJobAdminApi jobAdminApi;
    @Autowired
    private ApplyInterfaceMapper applyInterfaceMapper;

    @ResponseBody
    @GetMapping(value={"getAppInfos"})
    public CommonResponse<JSONObject> getAppInfos() {
        JSONObject result = new JSONObject();
        List appList = this.appService.list((Wrapper)new QueryWrapper().eq((Object)"dr", (Object)0));
        result.put("allAppNum", (Object)appList.size());
        List interfaceList = this.interfaceService.list((Wrapper)new QueryWrapper().eq((Object)"dr", (Object)0));
        result.put("allAPINum", (Object)interfaceList.size());
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.setPageSize(-1);
        IPage records = this.mongodbCrudTemplate.queryPage(queryParam, "ejc_asipapi_log");
        result.put("allAPICallNum", (Object)records.getRecords().size());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @ResponseBody
    @GetMapping(value={"getJobInfos"})
    public CommonResponse<Map<String, Object>> getJobInfos() {
        CommonResponse response = this.jobAdminApi.dashboardInfo();
        Map result = (Map)response.getData();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @ResponseBody
    @GetMapping(value={"getAppAndApiInfo"})
    public CommonResponse<List<JSONObject>> getAppAndApiInfo() {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", this.appService.getAppAndApiInfo());
    }

    @ResponseBody
    @GetMapping(value={"getMyApiInfo"})
    public CommonResponse<JSONObject> getMyApiInfo() {
        JSONObject result = new JSONObject();
        Integer count = this.applyInterfaceMapper.getApplyInterfaceCount(InvocationInfoProxy.getUserid());
        result.put("myApiNum", (Object)count);
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.setPageSize(-1);
        queryParam.getParams().put("userId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        String startOfDay = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()) + " 00:00:00";
        String endOfDay = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()) + " 23:59:59";
        queryParam.getParams().put("reqTime", new Parameter("between", (Object)(startOfDay + "," + endOfDay)));
        IPage records = this.mongodbCrudTemplate.queryPage(queryParam, "ejc_asipapi_log");
        result.put("myApiCallNum", (Object)records.getRecords().size());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @ResponseBody
    @GetMapping(value={"pieAndBarInfo"})
    public CommonResponse<Map<String, Object>> pieAndBarInfo(@RequestParam(required=false) String startDateStr, @RequestParam(required=false) String endDateStr) {
        if (startDateStr == null) {
            startDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtils.addDays((Date)new Date(), (int)-8)) + " 00:00:00";
        }
        if (endDateStr == null) {
            endDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtils.addDays((Date)new Date(), (int)-1)) + " 23:59:59";
        }
        return this.jobAdminApi.pieAndBarInfo(startDateStr, endDateStr);
    }
}

