/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.utils;

import com.ejianc.business.cefoc.asip.utils.SqlSyntaxHelper;
import com.ejianc.business.cefoc.asip.utils.sql.config.AggConfig;
import com.ejianc.business.cefoc.asip.utils.sql.config.CompositeConfig;
import com.ejianc.business.cefoc.asip.utils.sql.config.ConfigComponent;
import com.ejianc.business.cefoc.asip.utils.sql.config.DimensionConfig;
import com.ejianc.business.cefoc.asip.utils.sql.config.ValueConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class SqlHelper {
    private String tableName;
    private boolean isSubquery;
    private SqlSyntaxHelper sqlSyntaxHelper = new SqlSyntaxHelper();
    public static final String NULL_STRING = "#NULL";
    private Function<DimensionConfig, String> filter2SqlCondtion = config -> {
        if (config.getValues().size() == 0) {
            return null;
        }
        String fieldName = this.sqlSyntaxHelper.getProjectStr((DimensionConfig)config);
        String v0 = this.sqlSyntaxHelper.getDimMemberStr((DimensionConfig)config, 0);
        String v1 = null;
        if (config.getValues().size() == 2) {
            v1 = this.sqlSyntaxHelper.getDimMemberStr((DimensionConfig)config, 1);
        }
        if (NULL_STRING.equals(config.getValues().get(0))) {
            switch (config.getFilterType()) {
                case "=": 
                case "\u2260": {
                    return config.getColumnName() + ("=".equals(config.getFilterType()) ? " IS NULL" : " IS NOT NULL");
                }
            }
        }
        switch (config.getFilterType()) {
            case "=": 
            case "eq": {
                return fieldName + " IN (" + this.valueList((DimensionConfig)config) + ")";
            }
            case "\u2260": 
            case "ne": {
                return fieldName + " NOT IN (" + this.valueList((DimensionConfig)config) + ")";
            }
            case "LIKE": {
                List<String> values = config.getValues();
                String str = "";
                if (null != values && values.size() > 0) {
                    for (int i = 0; i < values.size(); ++i) {
                        String value = config.getValues().get(i);
                        String v = value.indexOf("%") > -1 ? "'" + value + "' " : "'%" + value + "%' ";
                        str = str + config.getColumnName() + " LIKE " + v;
                        if (i >= values.size() - 1) continue;
                        str = str + " AND ";
                    }
                }
                return str;
            }
            case ">": {
                return this.rangeQuery(fieldName, v0, null);
            }
            case "<": {
                return this.rangeQuery(fieldName, null, v0);
            }
            case "\u2265": {
                return this.rangeQuery(fieldName, v0, null, true, true);
            }
            case "\u2264": {
                return this.rangeQuery(fieldName, null, v0, true, true);
            }
            case "(a,b]": {
                return this.rangeQuery(fieldName, v0, v1, false, true);
            }
            case "[a,b)": {
                return this.rangeQuery(fieldName, v0, v1, true, false);
            }
            case "(a,b)": {
                return this.rangeQuery(fieldName, v0, v1, false, false);
            }
            case "[a,b]": {
                return this.rangeQuery(fieldName, v0, v1, true, true);
            }
        }
        return null;
    };

    public static ConfigComponent separateNull(ConfigComponent configComponent) {
        DimensionConfig cc;
        if (configComponent instanceof DimensionConfig && ("=".equals((cc = (DimensionConfig)configComponent).getFilterType()) || "\u2260".equals(cc.getFilterType())) && cc.getValues().size() > 1 && cc.getValues().stream().anyMatch(s -> NULL_STRING.equals(s))) {
            CompositeConfig compositeConfig = new CompositeConfig();
            compositeConfig.setType("=".equals(cc.getFilterType()) ? "OR" : "AND");
            cc.setValues(cc.getValues().stream().filter(s -> !NULL_STRING.equals(s)).collect(Collectors.toList()));
            compositeConfig.getConfigComponents().add(cc);
            DimensionConfig nullCc = new DimensionConfig();
            nullCc.setColumnName(cc.getColumnName());
            nullCc.setFilterType(cc.getFilterType());
            nullCc.setValues(new ArrayList<String>());
            nullCc.getValues().add(NULL_STRING);
            compositeConfig.getConfigComponents().add(nullCc);
            return compositeConfig;
        }
        return configComponent;
    }

    public SqlHelper() {
    }

    public SqlHelper(String tableName, boolean isSubquery) {
        this.tableName = tableName;
        this.isSubquery = isSubquery;
    }

    public String assembleFilterSql(AggConfig config) {
        String whereStr = null;
        if (config != null) {
            Stream c = config.getColumns().stream();
            Stream r = config.getRows().stream();
            Stream f = config.getFilters().stream();
            Stream<ConfigComponent> filters = Stream.concat(Stream.concat(c, r), f);
            whereStr = this.filterSql(filters, "WHERE");
        }
        return whereStr;
    }

    public String assembleFilterSql(Stream<ConfigComponent> filters) {
        return this.filterSql(filters, "WHERE");
    }

    public String assembleAggDataSql(AggConfig config) throws Exception {
        Stream c = config.getColumns().stream();
        Stream r = config.getRows().stream();
        Stream f = config.getFilters().stream();
        Stream<ConfigComponent> filters = Stream.concat(Stream.concat(c, r), f);
        Stream<DimensionConfig> dimStream = Stream.concat(config.getColumns().stream(), config.getRows().stream());
        String dimColsStr = this.assembleDimColumns(dimStream);
        String aggColsStr = this.assembleAggValColumns(config.getValues().stream());
        String whereStr = this.filterSql(filters, "WHERE");
        String groupByStr = StringUtils.isBlank((String)dimColsStr) || StringUtils.isBlank((String)aggColsStr) ? "" : "GROUP BY " + dimColsStr;
        StringJoiner selectColsStr = new StringJoiner(",");
        if (!StringUtils.isBlank((String)dimColsStr)) {
            selectColsStr.add(dimColsStr);
        }
        if (!StringUtils.isBlank((String)aggColsStr)) {
            selectColsStr.add(aggColsStr);
        }
        String fsql = null;
        fsql = this.isSubquery ? "\nSELECT %s \n FROM (\n%s\n) cb_view \n %s \n %s limit 1000" : "\nSELECT %s \n FROM %s \n %s \n %s limit 1000";
        String exec = String.format(fsql, selectColsStr, this.tableName, whereStr, groupByStr);
        return exec;
    }

    private String filterSql(Stream<ConfigComponent> filterStream, String prefix) {
        StringJoiner where = new StringJoiner("\nAND ", prefix + " ", "");
        where.setEmptyValue("");
        filterStream.map(e -> SqlHelper.separateNull(e)).map(e -> this.configComponentToSql((ConfigComponent)e)).filter(e -> e != null).forEach(where::add);
        return where.toString();
    }

    private String configComponentToSql(ConfigComponent cc) {
        if (cc instanceof DimensionConfig) {
            return this.filter2SqlCondtion.apply((DimensionConfig)cc);
        }
        if (cc instanceof CompositeConfig) {
            CompositeConfig compositeConfig = (CompositeConfig)cc;
            String sql = compositeConfig.getConfigComponents().stream().map(e -> SqlHelper.separateNull(e)).map(e -> this.configComponentToSql((ConfigComponent)e)).collect(Collectors.joining(" " + compositeConfig.getType() + " "));
            return "(" + sql + ")";
        }
        return null;
    }

    private String valueList(DimensionConfig config) {
        String resultList = IntStream.range(0, config.getValues().size()).boxed().map(i -> this.sqlSyntaxHelper.getDimMemberStr(config, (int)i)).collect(Collectors.joining(","));
        return resultList;
    }

    private String rangeQuery(String fieldName, Object from, Object to, boolean includeLower, boolean includeUpper) {
        String op;
        StringBuffer result = new StringBuffer();
        result.append("(");
        String gt = ">";
        String gte = ">=";
        String lt = "<";
        String lte = "<=";
        if (from != null) {
            op = includeLower ? ">=" : ">";
            result.append(fieldName + op + from);
        }
        if (to != null) {
            if (from != null) {
                result.append(" AND ");
            }
            op = includeUpper ? "<=" : "<";
            result.append(fieldName + op + to);
        }
        result.append(")");
        return result.toString();
    }

    private String rangeQuery(String fieldName, Object from, Object to) {
        return this.rangeQuery(fieldName, from, to, false, false);
    }

    public static String surround(String text, String quta) {
        return quta + text + quta;
    }

    private String assembleAggValColumns(Stream<ValueConfig> selectStream) {
        StringJoiner columns = new StringJoiner(", ", "", " ");
        columns.setEmptyValue("");
        selectStream.map(vc -> this.sqlSyntaxHelper.getAggStr((ValueConfig)vc)).filter(e -> e != null).forEach(columns::add);
        return columns.toString();
    }

    private String assembleDimColumns(Stream<DimensionConfig> columnsStream) {
        StringJoiner columns = new StringJoiner(", ", "", " ");
        columns.setEmptyValue("");
        columnsStream.map(g -> this.sqlSyntaxHelper.getProjectStr((DimensionConfig)g)).distinct().filter(e -> e != null).forEach(columns::add);
        return columns.toString();
    }

    public SqlHelper setSqlSyntaxHelper(SqlSyntaxHelper sqlSyntaxHelper) {
        this.sqlSyntaxHelper = sqlSyntaxHelper;
        return this;
    }

    public SqlSyntaxHelper getSqlSyntaxHelper() {
        return this.sqlSyntaxHelper;
    }
}

