package com.ejianc.business.cefoc.asip.controller;

import com.ejianc.business.cefoc.asip.service.IDataTransferService;
import com.ejianc.business.cefoc.asip.vo.PublishDataVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 数据传输Controller
 * 
 * @author xg
 * @date 2018-05-09
 */
@Controller
@RequestMapping(value = "dataTransfer")
public class DataTransferController {

	private static final Logger LOGGER = LoggerFactory.getLogger(DataTransferController.class);

	@Autowired
	private IDataTransferService service;

	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "transferBySql")
	public CommonResponse<String> transferBySql(@RequestBody PublishDataVO vo) {
		service.transferBySql(vo);
		return CommonResponse.success("发布数据成功");
	}
}
