package com.ejianc.business.cefoc.asip.service.impl;

import com.ejianc.business.cefoc.asip.bean.ApplyEntity;
import com.ejianc.business.cefoc.asip.bean.ApplyInterfaceEntity;
import com.ejianc.business.cefoc.asip.service.IApplyService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.Base64Util;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("cefocAsipApply")
public class ApplyBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IApplyService applyService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ApplyEntity entity = applyService.selectById(billId);
		String clientId = IdWorker.getId()+"";
		String clientSecret = Base64Util.encode(clientId.getBytes());
		entity.setClientId(clientId);
		entity.setClientSecret(clientSecret);
		for (ApplyInterfaceEntity applyInterfaceEntity : entity.getApplyInterfaceList()) {
			applyInterfaceEntity.setClientId(clientId);
			applyInterfaceEntity.setClientSecret(clientSecret);
			applyInterfaceEntity.setRowState("edit");
		}
		applyService.saveOrUpdate(entity, false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		//TODO
		ApplyEntity entity = applyService.selectById(billId);
		entity.setClientId(null);
		entity.setClientSecret(null);
		for (ApplyInterfaceEntity applyInterfaceEntity : entity.getApplyInterfaceList()) {
			applyInterfaceEntity.setClientId(null);
			applyInterfaceEntity.setClientSecret(null);
			applyInterfaceEntity.setRowState("edit");
		}
		applyService.saveOrUpdate(entity, false);
		return CommonResponse.success();
	}

}
